% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renewal.R
\name{renewal}
\alias{renewal}
\title{Parliamentary Renewal}
\usage{
renewal(
  seats = NULL,
  dropout = NULL,
  defeated = NULL,
  reelected = NULL,
  type = "all"
)
}
\arguments{
\item{seats}{(\code{numeric}). Number of legislative seats in dispute}

\item{dropout}{(\code{numeric}). Number of parliamentarians who gave up the legislative career and vacancy for various reasons}

\item{defeated}{(\code{numeric}). Number of defeated parliamentarians}

\item{reelected}{(\code{numeric}). Number of re-elected parliamentarians}

\item{type}{(\code{character}). type of renewal to be calculated. by default it is \code{"all"}.
But only one renewal can be chosen: \code{"grr"} (gross renewal rate), \code{"crr"} (compulsory renewal rate), \code{"nrr"} (net renewal rate).}
}
\value{
A percentage which is the Renewal Rate. See parameter type.
}
\description{
`renewal` calculates parliamentary renewal rates
}
\details{
gross renewal rate = ((dropout + defeated) / seats) * 100

compulsory renewal rate = (dropout / seats) * 100

net renewal rate = (defeated / (reelected + defeated)) * 100
}
\examples{

seats <- 27
dropout <- 9
defeated <- 6
reelected <- 12

renewal(seats, dropout, defeated, reelected)

}
\references{
SANTOS, W. G. D. (2002). Votos e partidos: almanaque de dados eleitorais. Brasil e outros países. Rio de Janeiro: Editora FGV.
}
