% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angles.R
\name{fib_latt}
\alias{fib_latt}
\title{Fibonacci lattice on the sphere}
\usage{
fib_latt(n)
}
\arguments{
\item{n}{number of points to be produced.}
}
\value{
A matrix of size \code{c(n, 3)} with the spherical coordinates.
}
\description{
Computes the Fibonacci lattice on the sphere \eqn{\mathcal{S}^2}
to produce pseudo-equispaced points.
}
\examples{
scatterplot3d::scatterplot3d(
  fib_latt(n = 200), pch = 19, color = viridis::viridis(200),
  xlim = c(-1, 1), ylim = c(-1, 1), zlim = c(-1, 1),
  xlab = "", ylab = "", zlab = "")
}
