% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lf_to_tdf.R
\name{lf_to_tdf}
\alias{lf_to_tdf}
\title{Transform LF to TDF}
\usage{
lf_to_tdf(x)
}
\arguments{
\item{x}{A data frame in LF format ideally coming out of the clean_scores
function.}
}
\value{
A transformed data frame in TDF format.
}
\description{
This function transforms a data frame from LF (long format) to TDF (table
format),performing various data manipulation steps such as spreading data
across columns,removing NA and/or 0 columns, merging ID allele heights
within each replicate,transposing the table, converting from character to
numeric class, and replacing empty data with "0".
}
\examples{
scores<- data.frame(ID=c("104.1a","105.2b","106.3c","107.4d","108.5e",
"109.6f"),
filename=c("104.1a_FA060920_2020-06-09_C05.fsa_Sa.1",
"105.2b_FA060920_2020-06-09_C05.fsa_Sa.1",
"106.3c_FA060920_2020-06-09_C05.fsa_Fa.1",
"107.4d_FA060920_2020-06-09_C05.fsa_Sa.1" ,
"108.5e_FA060920_2020-06-09_C05.fsa_Sa.1" ,
"109.6f_SA060920_2020-06-09_C05.fsa_Fa.1"),
hei=c(2000,3000,4000,5000,2500, 1000),
pos=c(2000,3000,4000,5000,2500, 1000),
wei=c(290,285,280,275,270,260),
row.names= c("104.1a_FA060920_2020-06-09_C05.fsa_Sa.1",
"105.2b_FA060920_2020-06-09_C05.fsa_Sa.1",
"106.3c_FA060920_2020-06-09_C05.fsa_Fa.1",
"107.4d_FA060920_2020-06-09_C05.fsa_Sa.1" ,
"108.5e_FA060920_2020-06-09_C05.fsa_Sa.1" ,
"109.6f_SA060920_2020-06-09_C05.fsa_Fa.1"))

lf_to_tdf(scores)
}
