% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/how_far.R
\name{how_far}
\alias{how_far}
\title{Calculate pregnancy progress and time remaining}
\usage{
how_far(on_date = Sys.Date(), due_date = NULL, person = NULL)
}
\arguments{
\item{on_date}{Date or character string representing a date, e.g. "YYYY-MM-DD".
The date for which to calculate pregnancy progress.
Defaults to current system date.}

\item{due_date}{Date or character string representing a date, e.g. "YYYY-MM-DD".
The expected due date. If NULL, will try to use the "pregnancy.due_date" option.
Required if option not set.}

\item{person}{The person who is pregnant, to determine the grammar for the output message. Can be:
\itemize{
\item "I", "1", "1st", "first", or numeric \code{1} for first person
\item "you", "2", "2nd", "second", or numeric \code{2} for second person
\item Any other name for third person
\item \code{NULL}: will try to use the "pregnancy.person" option. Defaults to "You" if the option is set.
}}
}
\value{
Invisibly returns the number of days along in the pregnancy. Prints a formatted
message to the console with pregnancy progress information.
}
\description{
Calculates and displays how far along a pregnancy is on a specific date, including
weeks pregnant, days remaining until due date, and overall progress percentage.
}
\details{
The function assumes a standard pregnancy length of 280 days (40 weeks) when
calculating progress. It handles past, present, and future dates appropriately by
adjusting message grammar. If the calculation shows more than 42 weeks of pregnancy,
a different message is displayed noting this unusual duration.

The function uses the \href{https://cli.r-lib.org}{cli} package for formatted message output and supports
proper pluralization of weeks/days in messages.

If \code{on_date} or \code{due_date} are character strings, the conversion to a \code{Date}
is handled by \code{anytime::anydate()}.
}
\section{Global Options}{

\itemize{
\item pregnancy.due_date: Date object setting default due date
\item pregnancy.person: Character string setting default person
}
}

\examples{
# Current progress with explicit due date
# Note that output will depend on date the function is run
how_far(due_date = "2025-12-01")

# Progress on a specific date
how_far(on_date = "2025-11-01", due_date = "2025-12-01")

# With custom person
how_far(on_date = "2025-11-01", due_date = "2025-12-01", person = "Sarah")

# Set global options
date_opt <- getOption("pregnancy.due_date") # save current option
set_due_date("2025-12-01")
how_far()
options(pregnancy.due_date = date_opt) # return original option

}
\seealso{
\code{\link[=set_due_date]{set_due_date()}}, \code{\link[=set_person]{set_person()}}
}
