% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_combination.R
\name{linear_combination}
\alias{linear_combination}
\title{Test a single linear restriction of a model}
\usage{
linear_combination(regresults, R)
}
\arguments{
\item{regresults}{A list containing two items: \code{coefficients},
which is a vector of coefficient estimates, and \code{vcov},
which is the variance-covariance matrix of the coefficient estimates.}

\item{R}{A vector of length equal to the number of coefficients,
representing weights on each of the parameters.}
}
\value{
List with the following values:
\itemize{
\item \code{estimate}, the point estimate of the linear combination
\item \code{se}, the standard error of the point estimate
\item \code{p_value}, the p-value for the null hypothesis that the
linear combination is equal to zero
}
}
\description{
\code{linear_combination} takes a set of regression results
and a vector representing a linear combination of the
parameters and returns the estimate, standard error,
and p-value for the null hypothesis that the linear
combination is equal to zero.
}
\examples{
\dontshow{if (requireNamespace("estimatr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# test that the returns to one year of education are equal to ten years of age
model <- estimatr::lm_robust(earnwk ~ age + educ, data = cps)
R <- c(0, -10, 1) # 0 * `intercept` - 10 * `age` + 1 * `education`
linear_combination(model, R)
\dontshow{\}) # examplesIf}
}
