% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vars.R
\name{get_vars}
\alias{get_vars}
\title{Calculate Group Variance}
\usage{
get_vars(individual_array, n_replicates)
}
\arguments{
\item{individual_array}{The array of data for an individual}

\item{n_replicates}{The number of replicate groups}
}
\value{
A list, where the elements are:

\if{html}{\out{<div class="sourceCode">}}\preformatted{     1. variances: A vector of the variances of the sample
     2. total_sum: The sum of all the measurements in the sample
     3. ssq: The sum of all the squares of the measurements in the sample
     4. num_measurements: The total number of measurements in the sample that are not null
}\if{html}{\out{</div>}}
}
\description{
Calculate Group Variance
}
\details{
For the given individual array, for all rows of times, computes the variance in values
over replicates.

Returns these variances, sum of all values (for all times and replicates),
sum of all these values squared, and the number of values.
}
\examples{
arr <- data.frame(
  individual=c("a", "a"),
  time=c(5, 15),
  col_a=c(1, 2),
  col_b=c(2, 3)
)
variance_return <- get_vars(individual_array=arr, n_replicates=2)
print(variance_return)

}
