% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecificationAccessors.R
\name{treatment}
\alias{treatment}
\alias{treatment,StudySpecification-method}
\alias{treatment<-}
\alias{treatment<-,StudySpecification-method}
\alias{units_of_assignment}
\alias{units_of_assignment,StudySpecification-method}
\alias{units_of_assignment<-}
\alias{units_of_assignment<-,StudySpecification-method}
\alias{clusters}
\alias{clusters,StudySpecification-method}
\alias{clusters<-}
\alias{clusters<-,StudySpecification-method}
\alias{unitids}
\alias{unitids,StudySpecification-method}
\alias{unitids<-}
\alias{unitids<-,StudySpecification-method}
\alias{blocks}
\alias{blocks,StudySpecification-method}
\alias{blocks<-}
\alias{blocks<-,StudySpecification-method}
\alias{has_blocks}
\alias{forcings}
\alias{forcings,StudySpecification-method}
\alias{forcings<-}
\alias{forcings<-,StudySpecification-method}
\title{Accessors and Replacers for \code{StudySpecification} objects}
\usage{
treatment(x, newdata = NULL, dichotomy = NULL, by = NULL, ...)

\S4method{treatment}{StudySpecification}(x, newdata = NULL, dichotomy = NULL, by = NULL, ...)

treatment(x) <- value

\S4method{treatment}{StudySpecification}(x) <- value

units_of_assignment(x, newdata = NULL, by = NULL)

\S4method{units_of_assignment}{StudySpecification}(x, newdata = NULL, by = NULL)

units_of_assignment(x) <- value

\S4method{units_of_assignment}{StudySpecification}(x) <- value

clusters(x, newdata = NULL, by = NULL)

\S4method{clusters}{StudySpecification}(x, newdata = NULL, by = NULL)

clusters(x) <- value

\S4method{clusters}{StudySpecification}(x) <- value

unitids(x)

\S4method{unitids}{StudySpecification}(x)

unitids(x) <- value

\S4method{unitids}{StudySpecification}(x) <- value

blocks(x, newdata = NULL, by = NULL, ...)

\S4method{blocks}{StudySpecification}(x, newdata = NULL, by = NULL, ..., implicit = FALSE)

blocks(x) <- value

\S4method{blocks}{StudySpecification}(x) <- value

has_blocks(x)

forcings(x, newdata = NULL, by = NULL)

\S4method{forcings}{StudySpecification}(x, newdata = NULL, by = NULL)

forcings(x) <- value

\S4method{forcings}{StudySpecification}(x) <- value
}
\arguments{
\item{x}{a \code{StudySpecification} object}

\item{newdata}{optional; an additional \code{data.frame}. If passed, and the
unit of assignment variable is found in \code{newdata}, then the requested
variable type for each unit of \code{newdata} is returned. See \code{by}
argument if the name of the unit of assignment differs.}

\item{dichotomy}{optional; a formula specifying how to dichotomize a
non-binary treatment variable. See the Details section of the \code{ett()}
or \code{att()} help pages for information on specifying this formula}

\item{by}{optional; named vector or list connecting names of unit of
assignment/unitid/cluster variables in \code{x} to unit of
assignment/unitid/cluster variables in \code{data}. Names represent
variables in \code{x}; values represent variables in \code{newdata}. Only
needed if variable names differ.}

\item{...}{ignored.}

\item{value}{replacement. Either a \code{vector}/\code{matrix} of
appropriate dimension, or a named \code{data.frame} if renaming variable
as well. See \code{Details}.}

\item{implicit}{Should a block-less \code{StudySpecification} return a
constant 1 when extracting \code{blocks}?}
}
\value{
\code{data.frame} containing requested variable, or an updated
\code{StudySpecification}. \code{\link[=treatment]{treatment()}} works slightly differently, see
\code{Details}.
}
\description{
Allows access to the elements which define a
\code{StudySpecification}, enabling their extraction or replacement.
}
\details{
For \code{\link[=treatment]{treatment()}}, when argument \code{binary} is \code{FALSE}, the
treatment variable passed into the \code{StudySpecification} is returned
as a one-column \code{data.frame} regardless of whether it is binary or
\code{x} has a \code{dichotomy}

If a \code{dichotomy} is passed, a binary one-column \code{data.frame}
will be returned. If not and \code{binary} is \code{TRUE}, unless the
\code{StudySpecification} has a binary treatment, \code{\link[=treatment]{treatment()}} will
error. If \code{binary} is \code{"ifany"}, it will return the original
treatment in this case.

The one-column \code{data.frame} returned by \code{\link[=treatment]{treatment()}} is named as
entered in the \code{StudySpecification} creation, but if a
\code{dichotomy} is passed, the column name is \code{"__z"} to try and
avoid any name conflicts.

For the \code{value} when using replacers, the replacement must have the
same number of rows as the \code{StudySpecification} (the same number of
units of assignment). The number of columns can differ (e.g. if the
\code{StudySpecification} were defined with two variable uniquely
identifying blocks, you can replace that with a single variable uniquely
identifying blocks, as long as it respects other restrictions.)

If the replacement value is a \code{data.frame}, the name of the columns
is used as the new variable names. If the replacement is a \code{matrix}
or \code{vector}, the original names are retained. If reducing the number
of variables (e.g., moving from two variables uniquely identifying to a
single variable), the appropriate number of variable names are retained.
If increasing the number of variables, a \code{data.frame} with names must
be provided.
}
\examples{
data(simdata)
spec <- obs_spec(z ~ unit_of_assignment(uoa1, uoa2), data = simdata)
blocks(spec) # empty
blocks(spec) <- data.frame(blks = c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5))
blocks(spec)
blocks(spec) <- c(5, 5, 4, 4, 3, 3, 2, 2, 1, 1)
blocks(spec) # notice that variable is not renamed
}
