% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teeMod.R
\name{confint.teeMod}
\alias{confint.teeMod}
\title{Confidence intervals with standard errors provided by
\code{vcov.teeMod()}}
\usage{
\method{confint}{teeMod}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{a fitted \code{teeMod} model}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing,
all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments to pass to \code{vcov.teeMod()}}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. These will be labelled as (1-level)/2 and 1 -
(1-level)/2 in \% (by default 2.5\% and 97.5\%)
}
\description{
An S3method for \code{stats::confint} that uses standard errors
computed using \code{vcov.teeMod()}. Additional arguments passed to this
function, such as \code{cluster} and \code{type}, specify the arguments of
the \code{vcov.teeMod()} call.
}
\details{
Rather than call \code{stats::confint.lm()},
\code{confint.teeMod()} calls \code{.confint_lm()}, a function internal to
the \code{propertee} package that ensures additional arguments in the
\code{...} of the \code{confint.teeMod()} call are passed to the internal
\code{vcov()} call.
}
