% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_lm.R
\name{.confint_lm}
\alias{.confint_lm}
\title{Produce confidence intervals for linear models}
\usage{
.confint_lm(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{a fitted \code{teeMod} model}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing,
all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments to pass to \code{vcov.teeMod()}}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. These will be labelled as (1-level)/2 and 1 -
(1-level)/2 in \% (by default 2.5\% and 97.5\%)
}
\description{
Produce confidence intervals for linear models
}
\details{
\code{.confint_lm()} is a copy of \code{stats::confint.lm} but
passes arguments in \code{...} to the \code{vcov()} call. When called on a
\code{teeMod} model, this produces confidence intervals where standard
errors are computed based on the desired formulation of the
\code{vcov_tee()} call.
}
\keyword{internal}
