% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_D4.R
\name{pool_D4}
\alias{pool_D4}
\title{Pools the Likelihood Ratio tests across Multiply Imputed datasets ( method D4)}
\usage{
pool_D4(data, nimp, impvar, fm0, fm1, robust = TRUE, model_type = "binomial")
}
\arguments{
\item{data}{Data frame with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar, and starting by 1.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{fm0}{the null model.}

\item{fm1}{the (nested) model to compare. Must be larger than the null model.}

\item{robust}{if TRUE a robust LRT is used (algorithm 1 in Chan and Meng), otherwise 
algorithm 2 is used.}

\item{model_type}{if TRUE (default) a logistic regression model is fitted, otherwise
a linear regression model is used}
}
\value{
The D4 statistic, the numerator, df1 and denominator, df2 degrees of freedom 
 for the F-test.
}
\description{
\code{pool_D4} The D4 statistic to combine the likelihood ratio tests (LRT)
 across Multiply Imputed datasets according method D4.
}
\examples{

fm0 <- Chronic ~ BMI + factor(Carrying) + 
  Satisfaction + SocialSupport + Smoking
fm1 <- Chronic ~ BMI + factor(Carrying) + 
  Satisfaction +  SocialSupport + Smoking +
  Radiation

psfmi::pool_D4(data=lbpmilr, nimp=10, impvar="Impnr",
               fm0=fm0, fm1=fm1, robust = TRUE)
   
}
\references{
Chan, K. W., & Meng, X.-L. (2019). Multiple improvements of multiple 
 imputation likelihood ratio tests. ArXiv:1711.08822 [Math, Stat]. https://arxiv.org/abs/1711.08822

Grund, Simon, Oliver Lüdtke, and Alexander Robitzsch. 2021. “Pooling Methods for 
 Likelihood Ratio Tests in Multiply Imputed Data Sets.” PsyArXiv. January 29. doi:10.31234/osf.io/d459g.
}
\author{
Martijn Heymans, 2021
}
