% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_stab.R
\name{psfmi_stab}
\alias{psfmi_stab}
\title{Function to evaluate bootstrap predictor and model stability in multiply imputed datasets.}
\usage{
psfmi_stab(
  pobj,
  boot_method = NULL,
  nboot = 20,
  p.crit = 0.05,
  start_model = TRUE,
  direction = NULL
)
}
\arguments{
\item{pobj}{An object of class \code{pmods} (pooled models), produced by a previous call to
\code{psfmi_lr}, \code{psfmi_coxr} or \code{psfmi_mm}.}

\item{boot_method}{A single string to define the bootstrap method. Use "single" after a call to
\code{psfmi_lr} and \code{psfmi_coxr} and "cluster" after a call to \code{psfmi_mm}.}

\item{nboot}{A numerical scalar. Number of bootstrap samples to evaluate the stability. Default is 20.}

\item{p.crit}{A numerical scalar. Used as P-value selection criterium during bootstrap model selection.}

\item{start_model}{If TRUE the bootstrap evaluation takes place from the start model of object pobj, if
FALSE the final model is used for the evaluation.}

\item{direction}{The direction of predictor selection, "BW" for backward selection and "FW"
  for forward selection.
#'}
}
\value{
A \code{psfmi_stab} object from which the following objects can be extracted: bootstrap
 inclusion (selection) frequency of each predictor \code{bif}, total number each predictor is
 included in the bootstrap samples as \code{bif_total}, percentage a predictor is selected
 in each bootstrap sample as \code{bif_perc} and number of times a prediction model is selected in
 the bootstrap samples as \code{model_stab}.
}
\description{
\code{psfmi_stab} Stability analysis of predictors and prediction models selected with
 the \code{psfmi_lr}, \code{psfmi_coxr} or \code{psfmi_mm} functions of the \code{psfmi} package.
}
\details{
The function evaluates predictor selection frequency in stratified or cluster bootstrap samples.
 The stratification factor is the variable that separates the imputed datasets. The same bootstrap cases
 are drawn in each bootstrap sample. It uses as input an object of class \code{pmods} as a result of a
 previous call to the \code{psfmi_lr}, \code{psfmi_coxr} or \code{psfmi_mm} functions.
 In combination with the \code{psfmi_mm} function a cluster bootstrap method is used where bootstrapping
 is used on the level of the clusters only (and not also within the clusters).
}
\section{Vignettes}{

 https://mwheymans.github.io/psfmi/articles/psfmi_StabilityAnalysis.html
}

\examples{
 pool_lr <- psfmi_coxr(formula = Surv(Time, Status) ~ Pain + factor(Satisfaction) + 
   rcs(Tampascale,3) + Radiation + Radiation*factor(Satisfaction) + Age + Duration + 
   Previous + Radiation*rcs(Tampascale, 3), data=lbpmicox, p.crit = 0.157, direction="FW",
   nimp=5, impvar="Impnr", keep.predictors = NULL, method="D1")

 pool_lr$RR_Model
 pool_lr$multiparm

\dontrun{
 stab_res <- psfmi_stab(pool_lr, direction="FW", start_model = TRUE,
     boot_method = "single", nboot=20, p.crit=0.05)
 stab_res$bif
 stab_res$bif_perc
 stab_res$model_stab
}

}
\references{
Heymans MW, van Buuren S. et al. Variable selection under multiple imputation using the bootstrap
  in a prognostic study. BMC Med Res Methodol. 2007;13:7-33.

Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
  covariates in logistic regression models after multiple imputation: power and applicability
  analysis. BMC Med Res Methodol. 2017;17(1):129.

Sauerbrei W, Schumacher M. A bootstrap resampling procedure for model building:
  application to the Cox regression model. Stat Med. 1992;11:2093–109.

Royston P, Sauerbrei W (2008) Multivariable model-building – a pragmatic approach to
  regression analysis based on fractional polynomials for modelling continuous variables. (2008).
  Chapter 8, Model Stability. Wiley, Chichester

Heinze G, Wallisch C, Dunkler D. Variable selection - A review and
 recommendations for the practicing statistician. Biom J. 2018;60(3):431-449.

http://missingdatasolutions.rbind.io/
}
