% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_functions.R
\name{keep_all_pretreatment_subset}
\alias{keep_all_pretreatment_subset}
\title{Keep All Pre-Treatment Subset}
\usage{
keep_all_pretreatment_subset(data, g, tp, ...)
}
\arguments{
\item{data}{the full dataset}

\item{g}{the current group}

\item{tp}{the current time period}

\item{...}{additional arguments}
}
\value{
list that contains the following elements:
\itemize{
\item \code{gt_data}: a \code{gt_data_frame} object that contains the
correct subset of data
\item \code{n1}: the number of observations in this subset
\item \code{disidx}: a vector of the correct ids for this subset
}
}
\description{
A function that takes an original data set and keeps all
data for all groups that are not-yet-treated by period \code{tp} as well
as for group \code{g}.

In particular, this keeps more data than functions like \code{two_by_two}
subset that use a fixed base period.

A main use case for this function is the interactive fixed effects approach
proposed in Callaway and Tsyawo (2023).
}
