% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_bootstrap.R
\name{panel_empirical_bootstrap}
\alias{panel_empirical_bootstrap}
\title{Panel Empirical Bootstrap}
\usage{
panel_empirical_bootstrap(
  attgt.list,
  ptep,
  setup_pte_fun,
  subset_fun,
  attgt_fun,
  extra_gt_returns,
  ...
)
}
\arguments{
\item{attgt.list}{list of attgt results from \code{compute.pte}}

\item{ptep}{\code{pte_params} object}

\item{setup_pte_fun}{This is a function that should take in \code{data},
\code{yname} (the name of the outcome variable in \code{data}),
\code{gname} (the name of the group variable),
\code{idname} (the name of the id variable),
and possibly other arguments such as the significance level \code{alp},
the number of bootstrap iterations \code{biters}, and how many clusters
for parallel computing in the bootstrap \code{cl}.  The key thing that
needs to be figured out in this function is which groups and time periods
ATT(g,t) should be computed in.  The function should
return a \code{pte_params} object which contains all of the parameters
passed into the function as well as \code{glist} and \code{tlist} which
should be ordered lists of groups and time periods for ATT(g,t) to be computed.

This function provides also provides a good place for error handling related
to the types of data that can be handled.

The \code{pte} package contains the function \code{setup_pte} that is
a lightweight function that basically just takes the data, omits
the never-treated group from \code{glist} but includes all other groups
and drops the first time period.  This works in cases where ATT would
be identified in the 2x2 case (i.e., where there are two time periods,
no units are treated in the first period and the identification strategy
"works" with access to a treated and untreated group and untreated
potential outcomes for both groups in the first period) --- for example,
this approach works if DID is the identification strategy.}

\item{subset_fun}{This is a function that should take in \code{data},
\code{g} (for group), \code{tp} (for time period), and \code{...}
and be able to return the appropriate \code{data.frame} that can be used
by \code{attgt_fun} to produce ATT(g=g,t=tp).  The data frame should
be constructed using \code{gt_data_frame} in order to guarantee that
it has the appropriate columns that identify which group an observation
belongs to, etc.}

\item{attgt_fun}{This is a function that should work in the case where
there is a single group and the "right" number of time periods to
recover an estimate of the ATT.  For example, in the contest of
difference in differences, it would need to work for a single group,
find the appropriate comparison group (untreated units), find the right
time periods (pre- and post-treatment), and then recover an estimate
of ATT for that group.  It will be called over and over separately
by groups and by time periods to compute ATT(g,t)'s.

The function needs to work in a very specific way.  It should take in the
arguments: \code{data}, \code{...}.  \code{data} should be constructed
using the function \code{gt_data_frame} which checks to make sure
that \code{data} has the correct columns defined.
\code{...} are additional arguments (such as
formulas for covariates) that \code{attgt_fun} needs.  From these arguments
\code{attgt_fun} must return a list with element \code{ATT} containing the
group-time average treatment effect for that group and that time period.

If \code{attgt_fun} returns an influence function (which should be provided
in a list element named \code{inf_func}), then the code will use the
multiplier bootstrap to compute standard errors for group-time average
treatment effects, an overall treatment effect parameter, and a dynamic
treatment effect parameter (i.e., event study parameter).  If
\code{attgt_fun} does not return an influence function, then the same
objects will be computed using the empirical bootstrap.  This is usually
(perhaps substantially) easier to code, but also will usually be (perhaps
substantially) computationally slower.}

\item{extra_gt_returns}{A place to return anything extra from particular
group-time average treatment effect calculations.  For DID, this might
be something like propensity score estimates, regressions of untreated
potential outcomes on covariates.  For ife, this could be something
like the first step regression 2sls estimates.  This argument is also
potentially useful for debugging.}

\item{...}{extra arguments that can be passed to create the correct subsets
of the data (depending on \code{subset_fun}), to estimate group time
average treatment effects (depending on \code{attgt_fun}), or to
aggregating treatment effects (particularly useful are \code{min_e},
\code{max_e}, and \code{balance_e} arguments to event study aggregations)}
}
\value{
\code{pte_emp_boot} object
}
\description{
Computes empirical bootstrap pointwise standard errors
}
