% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte_params.R
\name{pte_params}
\alias{pte_params}
\title{PTE Parameters Class}
\usage{
pte_params(
  yname,
  gname,
  tname,
  idname,
  data,
  glist,
  tlist,
  cband,
  alp,
  boot_type,
  anticipation = NULL,
  base_period = NULL,
  weightsname = NULL,
  control_group = "notyettreated",
  gt_type = "att",
  ret_quantile = 0.5,
  global_fun = FALSE,
  time_period_fun = FALSE,
  group_fun = FALSE,
  biters,
  cl,
  call = NULL
)
}
\arguments{
\item{yname}{Name of outcome in \code{data}}

\item{gname}{Name of group in \code{data}}

\item{tname}{Name of time period in \code{data}}

\item{idname}{Name of id in \code{data}}

\item{data}{balanced panel data}

\item{glist}{list of groups to create group-time average treatment effects
for}

\item{tlist}{list of time periods to create group-time average treatment
effects for}

\item{cband}{whether or not to report a uniform (instead of pointwise)
confidence band (default is TRUE)}

\item{alp}{significance level; default is 0.05}

\item{boot_type}{which type of bootstrap to use}

\item{anticipation}{how many periods before the treatment actually takes
place that it can have an effect on outcomes}

\item{base_period}{The type of base period to use.  This only affects
the numeric value of results in pre-treatment periods.  Results in
post-treatment periods are not affected by this choice.  The default
is "varying", where the base period will "back up" to the immediately
preceding period in pre-treatment periods.  The other option is "universal"
where the base period is fixed in pre-treatment periods to be the period
right before the treatment starts.  "Universal" is commonly used in
difference-in-differences applications, but can be unnatural for other
identification strategies.}

\item{weightsname}{The name of the column that contains sampling weights.
The default is NULL, in which case no sampling weights are used.}

\item{control_group}{Which group is used as the comparison group.
The default choice is "notyettreated", but
different estimation strategies can implement their own choices
for the control group}

\item{gt_type}{which type of group-time effects are computed.
The default is "att".  Different estimation strategies can implement
their own choices for \code{gt_type}}

\item{ret_quantile}{For functions that compute quantile treatment effects,
this is a specific quantile at which to report results, e.g.,
\code{ret_quantile = 0.5} will return that the qte at the median.}

\item{global_fun}{Logical indicating whether or not untreated potential
outcomes can be estimated in one shot, i.e., for all groups and time periods.
Main use case would be for one-shot imputation estimators.  Not supported yet.}

\item{time_period_fun}{Logical indicating whether or not untreated potential
outcomes can be estimated for all groups in the same time period.  Not supported yet.}

\item{group_fun}{Logical indicating whether or not untreated potential outcomes
can be estimated for all time periods for a single group.  Not supported yet.
These functions aim at reducing or eliminating running the same code multiple times.}

\item{biters}{number of bootstrap iterations; default is 100}

\item{cl}{number of clusters to be used when bootstrapping; default is 1}

\item{call}{keeps track of through the \code{call} from external functions/packages}
}
\value{
\code{pte_params} object
}
\description{
Class that contains pte parameters
}
