% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_scale1d.R
\name{textplot_scale1d}
\alias{textplot_scale1d}
\title{Plot a fitted scaling model}
\usage{
textplot_scale1d(
  x,
  margin = c("documents", "features"),
  doclabels = NULL,
  sort = TRUE,
  groups = NULL,
  highlighted = NULL,
  alpha = 0.7,
  highlighted_color = "black"
)
}
\arguments{
\item{x}{the fitted or predicted scaling model object to be plotted}

\item{margin}{\code{"documents"} to plot estimated document scores (the
default) or \code{"features"} to plot estimated feature scores by a measure
of relative frequency}

\item{doclabels}{a vector of names for document; if left NULL (the default),
docnames will be used}

\item{sort}{if \code{TRUE} (the default), order points from low to high
score. If a vector, order according to these values from low to high. Only
applies when \code{margin = "documents"}.}

\item{groups}{grouping variable for sampling, equal in length to the number
of documents. This will be evaluated in the docvars data.frame, so that
docvars may be referred to by name without quoting. This also changes
previous behaviours for \code{groups}. See \code{news(Version >= "3.0", package = "quanteda")} for details.}

\item{highlighted}{a vector of feature names to draw attention to in a
feature plot; only applies if \code{margin = "features"}}

\item{alpha}{A number between 0 and 1 (default 0.5) representing the level of
alpha transparency used to overplot feature names in a feature plot; only
applies if \code{margin = "features"}}

\item{highlighted_color}{colour for highlighted terms in \code{highlighted}}
}
\value{
a \pkg{ggplot2} object
}
\description{
Plot the results of a fitted scaling model, from (e.g.) a predicted
\link[quanteda.textmodels:textmodel_wordscores]{quanteda.textmodels::textmodel_wordscores} model or a fitted
\link[quanteda.textmodels:textmodel_wordfish]{quanteda.textmodels::textmodel_wordfish} or
\link[quanteda.textmodels:textmodel_ca]{quanteda.textmodels::textmodel_ca} model. Either document or feature
parameters may be plotted: an ideal point-style plot (estimated document
position plus confidence interval on the x-axis, document labels on the
y-axis) with optional renaming and sorting, or as a plot of estimated
feature-level parameters (estimated feature positions on the x-axis, and a
measure of relative frequency or influence on the y-axis, with feature names
replacing plotting points with some being chosen by the user to be
highlighted).
}
\note{
The \code{groups} argument only applies when \code{margin = "documents"}.
}
\examples{
library("quanteda")
if (require("quanteda.textmodels")) {
dfmat <- dfm(tokens(data_corpus_irishbudget2010))

## wordscores
refscores <- c(rep(NA, 4), 1, -1, rep(NA, 8))
tmod1 <- textmodel_wordscores(dfmat, y = refscores, smooth = 1)
# plot estimated document positions
textplot_scale1d(predict(tmod1, se.fit = TRUE),
                 groups = data_corpus_irishbudget2010$party)
# plot estimated word positions
textplot_scale1d(tmod1, margin = "features",
                 highlighted = c("minister", "have", "our", "budget"))

## wordfish
tmod2 <- quanteda.textmodels::textmodel_wordfish(dfmat, dir = c(6,5))
# plot estimated document positions
textplot_scale1d(tmod2)
textplot_scale1d(tmod2, groups = data_corpus_irishbudget2010$party)
# plot estimated word positions
textplot_scale1d(tmod2, margin = "features",
                 highlighted = c("government", "global", "children",
                                 "bank", "economy", "the", "citizenship",
                                 "productivity", "deficit"))

## correspondence analysis
tmod3 <- textmodel_ca(dfmat)
# plot estimated document positions
textplot_scale1d(tmod3, margin = "documents",
                 groups = docvars(data_corpus_irishbudget2010, "party"))
}
}
\seealso{
\code{\link[quanteda.textmodels:textmodel_wordfish]{quanteda.textmodels::textmodel_wordfish()}},
\code{\link[quanteda.textmodels:textmodel_wordscores]{quanteda.textmodels::textmodel_wordscores()}},
\code{\link[quanteda.textmodels:textmodel_ca]{quanteda.textmodels::textmodel_ca()}}
}
\author{
Kenneth Benoit, Stefan Müller, and Adam Obeng
}
\keyword{textplot}
