% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pCountOpenFFT.R
\name{pCountOpenFFT}
\alias{pCountOpenFFT}
\title{Fit FFT N-mixture Model}
\usage{
pCountOpenFFT(
  nit,
  K = NULL,
  starts = NULL,
  l_s_c = NULL,
  g_s_c = NULL,
  g_t_c = NULL,
  o_s_c = NULL,
  o_t_c = NULL,
  p_s_c = NULL,
  p_t_c = NULL,
  VERBOSE = FALSE,
  outfile = NULL,
  method = "BFGS",
  ...
)
}
\arguments{
\item{nit}{Matrix of counts data. Rows represent sites, columns represent sampling occasions. Note that if the data is a vector, then it will be converted to a matrix with a single row.}

\item{K}{Upper bound on summations in the likelihood function. K should be chosen large enough that the negative log likelihood function is stable (unchanging as K increases). If K=NULL, K=5*max(nit) will be used as default. Default: NULL}

\item{starts}{Either NULL for default starting values, or a vector of parameter values: \code{c(log(lambda), log(gamma), logit(omega), logit(pdet))}. Note that the parameter vector will need to be longer by one for each parameter coefficient if covariate values are supplied. The order of coefficients is: \code{c(lambda, l_s_c, gamma, g_s_c, g_t_c, omega, o_s_c, o_t_c, pdet, p_s_c, p_t_c)}}

\item{l_s_c}{List of lambda site covariates, Default: NULL}

\item{g_s_c}{List of gamma site covariates, Default: NULL}

\item{g_t_c}{List of gamma time covariates, Default: NULL}

\item{o_s_c}{List of omega site covariates, Default: NULL}

\item{o_t_c}{List of omega time covariates, Default: NULL}

\item{p_s_c}{List of pdet site covariates, Default: NULL}

\item{p_t_c}{List of pdet time covariates, Default: NULL}

\item{VERBOSE}{If TRUE, will print additional information during model fitting, Default: FALSE}

\item{outfile}{Location of csv file to write/append parameter values, can be used to checkpoint long running model fits. Default: NULL (no csv file created).}

\item{method}{Optimization method, passed to optim function, options include: "BFGS", "Nelder-Mead", "CG". Default: "BFGS"}

\item{...}{Additional arguments passed to the optimization function optim. For example: \code{control = list(trace=1, REPORT=1, reltol=1e-10)}}
}
\value{
Returns the fitted model object.
}
\description{
Fit an open population N-mixture model using the FFT method of computing the Transition Probability matrix. The four parameters are mean initial site abundance lambda, mean recruitments gamma, survival probability omega, and probability of detection pdet. Parameters can be made to vary over sites and over times by including parameter covariates. Note that this function is essentially a wrapper for optim acting on the nll_FFT function.
}
\examples{
if (interactive()) {
# No Covariates
nit = matrix(c(1,1,0,2,3), nrow=1) # observations for 1 site, 5 sampling occassions
model1 = pCountOpenFFT(nit, K=10)  # fit the model with population upper bound K=10

# Site Covariates
o_s_c = list(cov1=c(0,0,1)) # omega site covariates, cov1 is categorical
nit = matrix(c(1,1,0,2,3, 
               1,0,1,3,2, 
               4,1,3,2,0), nrow=3, byrow=T) # 3 sites, 5 sampling occassions
model2 = pCountOpenFFT(nit, K=20, o_s_c=o_s_c) # fit the model with population upper bound K=20

# Time Covariates
g_t_c = list(temp=c(0.5,0.3,0.6,0.7,NA)) # transition covariates: only first T-1=4 values used 
model3 = pCountOpenFFT(nit, K=10, g_t_c=g_t_c)  # fit the model with population upper bound K=10
}
}
