% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_readctl.R
\name{SS_readctl}
\alias{SS_readctl}
\title{Read control file from SS}
\usage{
SS_readctl(
  file,
  version = "3.30",
  verbose = FALSE,
  echoall = lifecycle::deprecated(),
  use_datlist = TRUE,
  datlist = "data.ss_new",
  nseas = NULL,
  N_areas = NULL,
  Nages = NULL,
  Ngenders = lifecycle::deprecated(),
  Nsexes = NULL,
  Npopbins = NA,
  Nfleets = NULL,
  Nfleet = NULL,
  Do_AgeKey = NULL,
  Nsurveys = NULL,
  N_tag_groups = NULL,
  N_CPUE_obs = NULL,
  catch_mult_fleets = NULL,
  predM_fleets = NULL,
  Ntag_fleets = NULL,
  N_rows_equil_catch = NULL,
  N_dirichlet_parms = NULL,
  ptype = FALSE
)
}
\arguments{
\item{file}{Filename either with full path or relative to working directory.

See the formal arguments for a possible default filename.}

\item{version}{SS version number. Currently "3.24" or "3.30" are supported,
either as character or numeric values (noting that numeric 3.30  = 3.3).
\code{version = NULL} is no longer the default or an allowed entry.
The default is \code{version = "3.30"}.}

\item{verbose}{Should there be verbose output while running the file?
Defaults to FALSE.}

\item{echoall}{Deprecated. Debugging tool (not fully implemented) of echoing
blocks of values as it is being read.}

\item{use_datlist}{LOGICAL. If TRUE, use datlist to derive parameters which
can not be determined from control file. Defaults to TRUE.}

\item{datlist}{list or character. If list, should be a list produced from
\code{\link[=SS_writedat]{SS_writedat()}}. If character, should be the file name of an SS data file.}

\item{nseas}{number of seasons in the model. This information is not
explicitly available in control file and used only if \code{use_datlist = FALSE}.}

\item{N_areas}{number of spatial areas in the model. Default = 1. This information is not
explicitly available in control file and used only if if \code{use_datlist = FALSE}.}

\item{Nages}{oldest age in the model. This information is also not
explicitly available in control file and used only if \code{use_datlist = FALSE}.}

\item{Ngenders}{Deprecated. Number of sexes in the model. This information is also not
explicitly available in control file and used only if \code{use_datlist = FALSE}.}

\item{Nsexes}{number of sexes in the model. This information is also not
explicitly available in control file and used only if \code{use_datlist = FALSE}.}

\item{Npopbins}{number of population bins in the model. This information is also not
explicitly available in control file and this information is only required if length based
maturity vector is directly supplied (Maturity option of 6).  and used only
if \code{use_datlist = FALSE}.}

\item{Nfleets}{Number of fishing fleets and surveys, for 3.30 models.}

\item{Nfleet}{Number of fishing fleets, for 3.24 and lower version models.}

\item{Do_AgeKey}{Flag to indicate if 7 additional ageing error parameters to
be read set 1 (but in fact any non zero numeric in R) or TRUE to enable to
read them 0 or FALSE to disable them. This information is not
explicitly available in control file and used only if \code{use_datlist = FALSE}.}

\item{Nsurveys}{Number of surveys, for 3.24 and lower version models.}

\item{N_tag_groups}{number of tag release group. Default =NA. This information
is not explicitly available control file  and used only if
\code{use_datlist = FALSE}. This information is only required if custom tag
parameters is enabled (TG_custom=1)}

\item{N_CPUE_obs}{Number of CPUE observations. Used only in control file 3.24
syntax if \code{use_datlist = FALSE}.}

\item{catch_mult_fleets}{Integer vector of fleets using the catch multiplier
option. Defaults to NULL and should be left as such if 1) the catch
multiplier option is not used for any fleet or 2) \code{use_datlist = TRUE} and
datlist is specified. Used only in control file 3.30 syntax if
\code{use_datlist = FALSE}.}

\item{predM_fleets}{integer vector of fleets with predator mortality included.
Predator mortality fleets are only available in v3.30.18 and
higher. Defaults to NULL and should be left as such if 1) predation mortality
is not used for any fleets; 2) \code{use_datlist = TRUE} and \code{datlist} is specified;
or 3) if comments in the control file should be used instead to determine
the the predM_fleets. Used only in control file 3.30 syntax if
\code{use_datlist = FALSE}.}

\item{Ntag_fleets}{The number of catch fleets in the model (fleets of )
type 1 or 2; not surveys). Used to set the number of survey parameters.
Only used in control file 3.30 reading if tagging data is in the model and
\code{use_datlist = FALSE}.}

\item{N_rows_equil_catch}{Integer value of the number of parameter lines to
read for equilibrium catch. Defaults to NULL, which means the function will
attempt to figure out how many lines of equilibrium catch to read from the
control file comments. Used only in control file 3.30 syntax if
\code{use_datlist = FALSE}.}

\item{N_dirichlet_parms}{Integer value of the number of Dirichlet-Multinomial
parameters. Defaults to 0. Used only in control file 3.30 syntax if
\code{use_datlist = FALSE}.}

\item{ptype}{LOGICAL if \code{TRUE}, which is the default,
a column will be included in the output indicating parameter type.
Using \code{TRUE} can be useful, but causes problems for \link{SS_writectl},
and therefore is not recommended if you intend to write the list
back out into a file.
Used only in control file 3.24 syntax.}
}
\value{
A list structure where each element is a section of the control file.
}
\description{
Read control file from Stock Synthesis (SS) into R as a list object.
This function acts as a wrapper for version-specific SS_readctl_ functions.
For example, if the control file was written using SS 3.24,
then \code{SS_readctl} will call \link{SS_readctl_3.24}. Input arguments that do not
pertain to the version of your control file can be left at their
default values.
}
\examples{
# Read in the 'simple' example SS model stored in r4ss
# Find the directory
dirsimple <- system.file("extdata", "simple_3.30.13", package = "r4ss")
# Read in the dat file to define the structure of the control file so that
# you don't have to specify things in the function call such as 'Nfleet'
datfilename <- dir(dirsimple, pattern = "data\\\\.ss", full.names = TRUE)
dat <- r4ss::SS_readdat(file = datfilename, verbose = FALSE)
# Read in the control file using a list object for datlist
ctl <- r4ss::SS_readctl(
  file = dir(dirsimple, pattern = "control\\\\.ss", full.names = TRUE),
  verbose = FALSE,
  datlist = dat, use_datlist = TRUE
)
# Read in the control file using a file name for datlist
ctl <- r4ss::SS_readctl(
  file = dir(dirsimple, pattern = "control\\\\.ss", full.names = TRUE),
  verbose = FALSE,
  datlist = datfilename, use_datlist = TRUE
)
}
\seealso{
See the following for version-specific SS_readctl functions:
SS_readctl_3.24
SS_readctl_3.30.
The returned list structure can be written back to the disk using
\link{SS_writectl}.\cr
See the following for other \code{SS_read} functions:
SS_readctl
SS_readdat
SS_readforecast
SS_readstarter
SS_readwtatage.\cr
}
\author{
Ian G. Taylor, Yukio Takeuchi, Neil L. Klaer
}
