% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SS_write.R
\name{SS_write}
\alias{SS_write}
\title{Write all Stock Synthesis input files for a model}
\usage{
SS_write(inputlist, dir = "", overwrite = FALSE, verbose = FALSE)
}
\arguments{
\item{inputlist}{list created by \code{\link[=SS_read]{SS_read()}}}

\item{dir}{A file path to the directory of interest.
Typically used with \code{file}, an additional input argument,
to specify input and output file paths.
The default value is \code{dir = NULL}, which leads to using
the current working directory, and thus, full file paths should
not be specified for other arguments as they will be appended
to \code{dir}.}

\item{overwrite}{A logical value specifying if the existing file(s)
should be overwritten. The default value is \code{overwrite = FALSE}.}

\item{verbose}{A logical value specifying if output should be printed
to the screen.}
}
\description{
Writes all the input files for a Stock Synthesis model using the list
created by \code{\link[=SS_read]{SS_read()}}
(presumably after modification of one or more elements)
using the \verb{SS_write*()} functions for the four or
five model input files.
}
\examples{
\dontrun{
# read inputlist to modify the data file
inputlist <- SS_read(
  dir = system.file("extdata", "simple_3.30.13", package = "r4ss")
)

# modify the starter file (use the par file)
inputlist[["start"]][["init_values_src"]] <- 1

# modify the data file (remove age comps from years prior to 1990)
inputlist[["dat"]][["agecomp"]] <- inputlist[["dat"]][["agecomp"]] \%>\%
  dplyr::filter(Yr >= 1990)

# modify the control file (turn off early recdevs and change range of yrs)
inputlist[["ctl"]][["recdev_early_phase"]] <-
  -abs(inputlist[["ctl"]][["recdev_early_phase"]])
inputlist[["ctl"]][["MainRdevYrFirst"]] <- 1980

# write the files to a new folder within the source directory
SS_write(
  inputlist = inputlist,
  dir = file.path(inputlist[["dir"]], "modified_inputs")
)
}
}
\seealso{
\itemize{
\item \code{\link[=SS_read]{SS_read()}} creates the list that is used by this function.
\item \code{\link[=SS_writestarter]{SS_writestarter()}}, \code{\link[=SS_writedat]{SS_writedat()}}, \code{\link[=SS_writectl]{SS_writectl()}},
\code{\link[=SS_writeforecast]{SS_writeforecast()}}, and \code{\link[=SS_writewtatage]{SS_writewtatage()}} are used to write the
input files.
}
}
\author{
Ian G. Taylor
}
