% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSgetMCMC.R
\name{SSgetMCMC}
\alias{SSgetMCMC}
\title{Read MCMC output.}
\usage{
SSgetMCMC(
  dir = NULL,
  verbose = TRUE,
  writecsv = FALSE,
  postname = "posteriors.sso",
  derpostname = "derived_posteriors.sso",
  csv1 = "keyposteriors.csv",
  csv2 = "nuisanceposteriors.csv",
  keystrings = c("NatM", "R0", "steep", "RecrDev_2008", "Q_extraSD"),
  nuisancestrings = c("Objective_function", "SSB_", "InitAge", "RecrDev"),
  burnin = 0,
  thin = 1
)
}
\arguments{
\item{dir}{Directory containing MCMC output.}

\item{verbose}{TRUE/FALSE switch to get more or less information about the
progress of the function.}

\item{writecsv}{Write key parameters and certainty nuisance quantities to a
CSV file.}

\item{postname}{Name of file with parameter posteriors (default matches
"posteriors.sso" used by SS, but the user could change the name)}

\item{derpostname}{Name of file with parameter posteriors (default matches
"derived_posteriors.sso" used by SS, but the user could change the name)}

\item{csv1}{First CSV file for key parameters.}

\item{csv2}{Second CSV file for nuisance quantities.}

\item{keystrings}{Vector of strings that partially match parameter names to
write to the file csv1. This file intended to feed into
\code{\link[=mcmc.out]{mcmc.out()}}.}

\item{nuisancestrings}{Vector of strings that partially match derived
quantity names to write to the file csv2. This file intended to feed into
\code{\link[=mcmc.nuisance]{mcmc.nuisance()}}.}

\item{burnin}{Optional burn-in value to apply on top of the option in the
starter file.}

\item{thin}{Optional thinning value to apply on top of the option in the
starter file and in the \code{-mcsave} runtime command.}
}
\description{
Reads the MCMC output (in the posteriors.sso and derived_posteriors.sso
files) from a model.
}
\seealso{
\code{\link[=mcmc.out]{mcmc.out()}}, \code{\link[=mcmc.nuisance]{mcmc.nuisance()}},
\code{\link[=SSplotPars]{SSplotPars()}}
}
\author{
Ian Taylor
}
