% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r4ss-package.R
\docType{package}
\name{r4ss-package}
\alias{r4ss}
\alias{r4ss-package}
\title{r4ss: R Code for Stock Synthesis}
\description{
A collection of R functions for use with Stock Synthesis, a fisheries stock assessment modeling platform written in ADMB by Dr. Richard D. Methot at the NOAA Northwest Fisheries Science Center. The functions include tools for summarizing and plotting results, manipulating files, visualizing model parameterizations, and various other common stock assessment tasks. This version of '{r4ss}' is compatible with Stock Synthesis versions 3.24 through 3.30 (specifically version 3.30.19.01, from April 2022).
}
\examples{
\dontrun{
# read in the report file using SS_output
myreplist <- SS_output(dir = "c:/SS/simple/")

# make a collection of plots using SS_plots
SS_plots(replist = myreplist)
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r4ss/r4ss}
  \item Report bugs at \url{https://github.com/r4ss/r4ss/issues}
}

}
\author{
\strong{Maintainer}: Ian G. Taylor \email{Ian.Taylor@noaa.gov}

Authors:
\itemize{
  \item Ian J. Stewart
  \item Allan C. Hicks
  \item Tommy M. Garrison
  \item Andre E. Punt
  \item John R. Wallace
  \item Chantel R. Wetzel
  \item James T. Thorson
  \item Yukio Takeuchi
  \item Kotaro Ono
  \item Cole C. Monnahan
  \item Christine C. Stawitz
  \item Z. Teresa A'mar
  \item Athol R. Whitten
  \item Kelli F. Johnson
  \item Robbie L. Emmet
  \item Sean C. Anderson
  \item Gwladys I. Lambert
  \item Megan M. Stachura
  \item Andrew B. Cooper
  \item Andi Stephens
  \item Neil L. Klaer
  \item Carey R. McGilliard
  \item Iago Mosqueira
  \item Watal M. Iwasaki
  \item Kathryn L. Doering
  \item Andrea M. Havron
  \item Nathan Vaughan
  \item LaTreese S. Denson
  \item Ashleigh J. Novak
  \item Henning Winker
  \item Lee Qi
  \item Megumi Oshima
  \item Eric Fletcher
}

}
\keyword{internal}
