% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_SS_models.R
\name{run_SS_models}
\alias{run_SS_models}
\title{Run multiple Stock Synthesis models}
\usage{
run_SS_models(
  dirvec = NULL,
  model = "ss",
  extras = "-nox",
  systemcmd = FALSE,
  skipfinished = TRUE,
  intern = FALSE,
  verbose = TRUE,
  exe_in_path = FALSE
)
}
\arguments{
\item{dirvec}{List of directories containing the model files}

\item{model}{Executable name or path to executable (absolute path, or relative
to the working directory). First, if exe_in_path is
FALSE, The function will look an executable with the same name in each
element of dirvec. Then, if it is not found in each, the function will
assume that model is the path to the executable and there is only 1 copy of
the executable. Note that if there is an exe in your PATH with the same
name, this will be used even if exe_in_path is FALSE.}

\item{extras}{Additional commands to use when running SS. Default = "-nox"
will reduce the amount of command-line output.}

\item{systemcmd}{Should R call SS using "system" function instead of "shell".
This may be required when running R in Emacs. Default = FALSE.}

\item{skipfinished}{Skip any folders that already contain a Report.sso file.
This can be helpful if the function is interrupted.}

\item{intern}{Show output in the R console or save to a file?}

\item{verbose}{Return updates of function progress to the R console?}

\item{exe_in_path}{logical. If TRUE, will look for exe in the PATH. If FALSE,
will look for exe in the model folders. Default = FALSE.}
}
\value{
Returns table showing which directories had model run and which
had errors like missing executable or Report.sso already present
}
\description{
Loops over a vector of directories and iteratively runs SS in each one
}
\examples{
\dontrun{
extdata_mods <- system.file("extdata", package = "r4ss")
dirvec <- c(
  file.path(extdata_mods, "simple_3.30.12"),
  file.path(extdata_mods, "simple_3.30.13")
)
# if ss or ss.exe is available in both directories:
run_SS_models(dirvec = dirvec)
}

}
\seealso{
\code{\link[=copy_SS_inputs]{copy_SS_inputs()}},
\code{\link[=populate_multiple_folders]{populate_multiple_folders()}}
}
\author{
Ian Taylor
}
