% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_mesh.R
\name{export_mesh}
\alias{export_mesh}
\title{Export Mesh}
\usage{
export_mesh(
  cylinder,
  filename,
  format = "ply",
  radius = NULL,
  color = NULL,
  palette = NULL,
  facets = 6,
  normals = FALSE,
  alpha = 1
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame.}

\item{filename}{File name and path for exporting.
The file extension is automatically added if not present.}

\item{format}{Mesh file format. Defaults to \code{ply}.
Supported formats include \code{ply}, \code{obj}, \code{stl}, and \code{blender}.
\code{format = "blender"} exports the mesh in the qsm-blender-addons format.}

\item{radius}{Radius column name either quoted or unquoted.
Defaults to the modified radii.}

\item{color}{Optional cylinder color parameter.
\code{color} must be a single hex color string, a \code{grDevices::colors()}, a vector
of hex colors, or a quoted/unquoted column name.
Vectors must have the same length as the cylinder data frame.
\code{color = "random"} will generate a random color applied to all cylinders.
Defaults to branching order.}

\item{palette}{Optional cylinder color palette for numerical data.
Palettes include \code{colourvalues::color_palettes()} or a user supplied RGB
palette matrix with the length of cylinder. It can also be set to "random"
to generate a random palette. If combined with \code{color = "random"}, each
cylinder will have a random, distinct color.}

\item{facets}{The number of facets in the polygon cross section.
Defaults to 6. A higher number of facets improves visual smoothness at the
cost of plotting speed, performance and memory.}

\item{normals}{Export surface normals per vertex. Defaults to FALSE.}

\item{alpha}{Set the transparency of the cylinders used in the "ply" format.
Defaults to 1. 1 is opaque and 0 is fully transparent.}
}
\value{
A mesh file
}
\description{
Exports a QSM cylinder mesh in various formats
}
\examples{

## Load QSM
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_treeqsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

# PLY
filename <- tempfile(pattern = "QSM_ply")
export_mesh(
  cylinder = cylinder,
  filename = filename,
  format = "ply",
  color = "distanceToTwig",
  palette = "viridis",
  normals = TRUE
)

# OBJ
filename <- tempfile(pattern = "QSM_obj")
export_mesh(
  cylinder = cylinder,
  filename = filename,
  format = "obj",
  normals = TRUE
)

# STL
filename <- tempfile(pattern = "QSM_stl")
export_mesh(
  cylinder = cylinder,
  filename = filename,
  format = "stl",
  normals = TRUE
)

# QSM Blender Addons
filename <- tempfile(pattern = "QSM_blender")
export_mesh(
  cylinder = cylinder,
  filename = filename,
  format = "blender",
  normals = TRUE
)

}
