% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closestCountry.R
\name{closestCountry}
\alias{closestCountry}
\title{Return country from point}
\usage{
closestCountry(pt, crs = 4326)
}
\arguments{
\item{pt}{longitude and latitude, as a numeric vector, 2-column table,
or spatial points object.}

\item{crs}{the CRS of the coordinate. If \code{pt} is a spatial object,
this argument is ignored. The default 4326 indicates longlat unprojected.}
}
\value{
If one point is provided, a character vector is returned.
If multiple points are provided, a list of character vectors is returned.
}
\description{
Determines which country a given point falls in.
}
\details{
Based on a predetermined set of global points, this function finds the country of 
	occurrence.
	This can be useful for checking the validity of a point by comparing the returned country 
	to the country listed with the occurrence record.
	If a point falls close to the boundary between two countries, the names of the nearby 
	countries are returned.
	This function will not be of much value if the point falls in the ocean, as it will 
	return the country that is closest, regardless of how far away it is.
}
\examples{
#point near a country border
closestCountry(c(-115.436, 32.657))

# testing different input options
samp <- sample(1:nrow(crotalus), 10)
xy <- crotalus[samp, c('decimallongitude', 'decimallatitude')]
sfpts <- sf::st_as_sf(xy, coords = c('decimallongitude', 'decimallatitude'), crs = 4326)
sfptsEA <- sf::st_transform(sfpts, crs = '+proj=eqearth')
spPts <- as(sfpts, 'Spatial')
closestCountry(xy)
closestCountry(sfpts)
closestCountry(sfptsEA)
closestCountry(spPts)

}
\author{
Pascal Title
}
