% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{dRatioOfQsprays}
\alias{dRatioOfQsprays}
\title{Partial differentiation}
\usage{
dRatioOfQsprays(roq, orders)
}
\arguments{
\item{roq}{object of class \code{ratioOfQsprays}}

\item{orders}{integer vector, the orders of the differentiation; e.g.
\code{c(2, 0, 1)} means that you differentiate two times with respect to
\eqn{x}, you do not differentiate with respect to \eqn{y}, and you
differentiate one time with respect to \eqn{z}}
}
\value{
A \code{ratioOfQsprays} object.
}
\description{
Partial differentiation of a \code{ratioOfQsprays} polynomial.
}
\examples{
library(ratioOfQsprays)
x <- qlone(1)
y <- qlone(2)
roq <- (x + 2*y  + 3*x*y) / (x + 1)
dRatioOfQsprays(roq, c(1, 1))
derivRatioOfQsprays(derivRatioOfQsprays(roq, 1), 2)
}
