% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filearray.R
\name{RAVEFileArray}
\alias{RAVEFileArray}
\title{'R6' wrapper for \code{'FileArray'}}
\description{
Wrapper for better serialization (check 'See also')
}
\seealso{
\code{\link{RAVESerializable}} \code{\link{rave-serialize-refhook}}
}
\section{Super class}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{RAVEFileArray}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{temporary}}{whether this file array is to be upon garbage collection;
default is false. The file array will be deleted if the
temporary flag is set to true and the array mode is \code{'readwrite'}}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{valid}}{whether the array is valid and ready to read}

\item{\code{@impl}}{the underlying array object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVEFileArray-@marshal}{\code{RAVEFileArray$@marshal()}}
\item \href{#method-RAVEFileArray-@unmarshal}{\code{RAVEFileArray$@unmarshal()}}
\item \href{#method-RAVEFileArray-new}{\code{RAVEFileArray$new()}}
\item \href{#method-RAVEFileArray-clone}{\code{RAVEFileArray$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEFileArray-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEFileArray-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Serialization helper, convert the object to a descriptive list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEFileArray$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEFileArray-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEFileArray-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Serialization helper, convert the object from a descriptive list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEFileArray$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object}}{serialized list}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEFileArray-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEFileArray-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEFileArray$new(x, temporary = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{file array or can be converted to \code{\link[filearray]{as_filearray}}}

\item{\code{temporary}}{whether this file array is to be deleted once the object
is out-of-scope; default is false}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVEFileArray-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVEFileArray-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVEFileArray$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
