% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{read-write-yaml}
\alias{read-write-yaml}
\alias{load_yaml}
\alias{save_yaml}
\title{Read write \code{'YAML'} format}
\usage{
load_yaml(file, ..., map = NULL)

save_yaml(x, file, ..., sorted = FALSE)
}
\arguments{
\item{file}{file to read from or write to}

\item{...}{passed to \code{\link{as.list}}}

\item{map}{a \code{fastmap} object; can be generated by \code{fastmap}
or \code{dipsaus} package; default is to create a new map internally}

\item{x}{list or map to write}

\item{sorted}{whether to sort the list by name; default is false}
}
\value{
A map object
}
\description{
supports reading data into a map object, and write the map
to files with names sorted for consistency
}
\examples{

tfile <- tempfile(fileext = ".yml")

save_yaml(list(b = 2, a = 1), tfile, sorted = TRUE)

cat(readLines(tfile), sep = "\n")

load_yaml(tfile)

unlink(tfile)


}
