% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_scene_to_obj.R
\name{write_scene_to_obj}
\alias{write_scene_to_obj}
\title{Write the scene to an OBJ file}
\usage{
write_scene_to_obj(scene, filename, materials = TRUE, fileext = ".obj")
}
\arguments{
\item{scene}{A rayvertex scene.}

\item{filename}{The filename for the OBJ file.}

\item{materials}{Default \code{TRUE}. Whether to write an MTL file to specify the materials for the OBJ.}

\item{fileext}{Default \code{".obj"}. The file extension to add to the filename.}
}
\value{
None
}
\description{
Writes the current scene to a Wavefront OBJ file, with or without materials
}
\examples{
if(run_documentation()) {
tmpfile = tempfile(fileext = ".obj")
write_scene_to_obj(generate_cornell_mesh(), tmpfile)
}
}
