% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_from_function-function.R
\name{data_from_function}
\alias{data_from_function}
\title{Generate causally-simulated data}
\usage{
data_from_function(func, n)
}
\arguments{
\item{func}{Functions, an object class generated by
\code{\link{function_from_edge}} or \code{\link{function_from_user}}
functions. All vertices must be defined for their functions. The causal
structure needs to be a directed acyclic graph (DAG), which means no loops
are allowed. Use \code{\link{edge_from_function}} to identify edges given a
list of functions, then draw a causal diagram using the edges data frame
(see vignettes). At least a function in the list must include 'n' as the
only argument. All arguments within any function must be defined by their
respective functions, except the argument 'n'. The output lengths of vertex
functions must match the specified length 'n'.}

\item{n}{Number of observations, a numeric of length 1, non-negative, and
non-decimal.}
}
\value{
A data frame which include the simulated data for each vertex as a
column.
}
\description{
Generate causally-simulated data
}
\examples{

data(functions)
data_from_function(functions, n = 100)
}
\keyword{time-fixed-data-generation}
