% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.pdf}
\alias{readDWD.pdf}
\title{open pdf data}
\usage{
readDWD.pdf(file, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
monthly_kl_historical_DESCRIPTION_obsgermany_climate_monthly_kl_historical_en.pdf}

\item{quiet}{Ignored. DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[berryFunctions:openFile]{berryFunctions::openFile()}} and from there to \code{\link[=system2]{system2()}}}
}
\value{
\code{\link[berryFunctions:openFile]{berryFunctions::openFile()}} output
}
\description{
open pdf file. This leads to less failures in the new \code{meta=TRUE}
}
\section{system in \code{\link[=selectDWD]{selectDWD()}}.\cr}{
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
}

\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests
link <- selectDWD(res="hourly", var="solar", per="r", meta=TRUE)
if(!any(endsWith(link,"pdf"))) stop("no pdf file here anymore") 
# hourly/sun no longer has a pdf file anymore 2023-09
link <- link[endsWith(link,"pdf")][1]
file <- dataDWD(link, read=FALSE)
readDWD(file) # opens in OS default PDF viewer

# for regular res/var combinations, use per=" " (since 1.8.29 2025-05-20)
link <- selectDWD(res="daily", var="kl", per=" ", meta=TRUE)
if(!any(endsWith(link,"pdf"))) stop("no pdf file here anymore") 
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2022.
}
