% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullmatch.R
\name{re_fullmatch}
\alias{re_fullmatch}
\title{Match a pattern against the entire string}
\usage{
re_fullmatch(pattern, string, ...)
}
\arguments{
\item{pattern}{A regular expression pattern or a compiled pattern object.}

\item{string}{A character vector where each element is a string to be matched against the pattern.}

\item{...}{
  Arguments passed on to \code{\link[=re_compile]{re_compile}}
  \describe{
    \item{\code{IGNORECASE}}{Flag to indicate case-insensitive matching.}
    \item{\code{I}}{Abbreviation for IGNORECASE.}
    \item{\code{MULTILINE}}{Flag to indicate multi-line matching, where \code{^} and \code{$} match the start and end of each line.}
    \item{\code{M}}{Abbreviation for MULTILINE.}
    \item{\code{DOTALL}}{Flag to indicate that \code{.} (dot) should match any character including newline.}
    \item{\code{S}}{Abbreviation for DOTALL}
    \item{\code{VERBOSE}}{Flag to allow a more verbose regex syntax, which can include comments and whitespace for readability.}
    \item{\code{X}}{Abbreviation for VERBOSE}
    \item{\code{NOFLAG}}{Flag to indicate that no flags should be set.}
  }}
}
\value{
A list where each element is a character vector containing the full match for the corresponding element of
\code{string}, or \code{character(0)} if there is no match.
}
\description{
\code{re_fullmatch} checks whether each element of a character vector fully matches a specified pattern
(regular expression). If the provided pattern is not already a compiled pattern object, it compiles it using
\code{re_compile}. The function ensures that the entire string matches the pattern from start to end.
}
\examples{
pattern <- re_compile("\\\\d{3}-\\\\d{2}-\\\\d{4}")
re_fullmatch(pattern, "123-45-6789") # Full match
re_fullmatch("123-45-6789", "123-45-6789 and more") # No full match
}
\seealso{
\href{https://docs.python.org/3/library/re.html#re.fullmatch}{Python re.fullmatch() documentation}
}
