#' Distribuția numărului de ore pe două zile, la anumite clase
#'
#' Sunt de vizat clasele care în prima zi au mai multe ore, decât în a doua zi
#' (urmând să echilibrăm, prin mutarea unei ore din prima, în a doua zi).
#'
#' @param DZ Distribuția curentă pe zile a tuturor lecțiilor
#' @param z1,z2 elemente din vectorul 'Zile'
#' @return Matricea distribuțiilor pentru clasele cu mai multe ore în prima,
#'     ca în a doua zi
#' @export
#'
cls_2days <- function(DZ, z1, z2) {
    stopifnot("z1 and z2 must be in 'Zile'"=all(c(z1,z2) %in% Zile))
    D <- DZ %>% filter(.data$zl %in% c(z1, z2)) %>% droplevels()
    M <- table(D[c('cls', 'zl')])
    M[M[, 1] > M[, 2], ]
}

