#' O repartizare pe zile a lecțiilor de desfășurat într-o școală
#'     pe parcursul unei săptămâni (în "format lung")
#'
#' Set de 928 lecții prof | cls | zl (repartizate deja pe zile).
#' Repartiția respectivă este într-o anumită măsură, echilibrată: 
#' numărul de ore/zi la fiecare clasă este cuprins între 5 și 7; fiecare 
#' profesor are nu mai mult de 7 ore/zi; poate cu unele excepții (când este
#' omogenă), distribuția pe zile a lecțiilor profesorului este cvasi-omogenă
#' (diferind cu cel mult două ore, de la o zi la alta).

#' @format
#' \describe{
#'     \item{prof}{Cod de 3 sau 6 caractere, reprezentând un profesor,
#'         respectiv un cuplaj (doi profesori, pe grupe ale unei clase);
#'         primele două litere abreviază disciplina pe care este încadrat
#'         profesorul, iar cifra care urmează indexează profesorii
#'         de pe aceeași disciplină}
#'     \item{cls}{Clasa (două sau trei caractere) la care profesorul are de
#'         făcut o lecție} 
#'     \item{zl}{Ziua în care a fost alocată lecția}
#' }
"R123"
#'
#' Lecții tuplate: perechi sau triplete de lecții prof|cls care trebuie
#'     să rămână în câte o aceeași zi
#'
#' Set conținând 27 de tuplaje asociate setului 'R123'. Un tuplaj 
#' va angaja într-un același moment (zi și oră), doi (sau trei) profesori
#' și două (respectiv, trei) clase (după anumite criterii, elevii reuniți
#' ai claselor respective sunt redistribuiți ad-hoc în noi "clase", în
#' locul și cu numele celor inițiale). De separat cu câte un spațiu, 
#' profesorii, respectiv clasele tuplajului (respectiv, zilele alocate).

#' @format
#' \describe{
#'     \item{prof}{Profesorii care trebuie să intre în același moment, la câte
#'         una dintre clasele respective}
#'     \item{cls}{Clasele la care profesorii din tuplaj au de făcut câte
#'         o lecție, în câte o aceeași zi (și oră)}
#'     \item{zl}{Ziua sau zilele alocate tuplajului în setul 'R123'}
#' }
"TPL"
#'
#' Zilele de lucru
#'
#' Factor prin care denumim zilele în care sunt alocate lecțiile.
#'
#' @format
#' \describe{
#'     \item{Zile}{Abrevieri pe câte două litere, ale zilelor de lucru.}
#' }
"Zile"
#'
#' Repartizarea finală pe zile (plecând de la 'R123' și 'TPL')
#'
#' A vedea 'vignette(package="recastlessons")'
#'
#' @format
#' \describe{
#'     \item{prof}{Profesorii și cuplajele}
#'     \item{cls}{Clasa la care profesorul are de făcut o lecție} 
#'     \item{zl}{Ziua în care a fost (re)alocată lecția}
#' }
"DZ"


