#' Profesorii (și distribuțiile de lecții) care la o anumită clasă 
#' au ore într-o anumită zi și nu au ore într-o altă anumită zi.
#'
#' Dacă o clasă apare în ambele zile la un profesor, atunci clasa respectivă
#' nu ar trebui mutată din prima zi în a doua (în principiu, la fiecare 
#'  disciplină trebuie să avem câte cel mult o singură oră/zi). 
#'
#' @param DZ Distribuția de lecții pe care se investighează.
#' @param K Clasă.
#' @param z1,z2 Cele două zile (neapărat, elemente din vectorul 'Zile')
#' @return Tabelul distribuțiilor profesorilor care au ore la clasa 'Cls'
#'     în ziua 'z1' dar nu și în ziua 'z2'.
#' @export

prof_2days <- function(DZ, K, z1, z2) {
    stopifnot("z1 and z2 must be in 'Zile'"=all(c(z1,z2) %in% Zile))
    Q <- DZ %>% filter(.data$cls == K & .data$zl %in% c(z1, z2))
    Q <- split(Q, Q$zl)
    Pr <- setdiff(Q[[z1]]$prof, Q[[z2]]$prof)
    if(length(Pr) == 0) return(NULL)
    NH <- table(DZ[c('prof', 'zl')])[Pr, ]
    if(length(Pr) == 1) { # evită 'array' unidimensional
        dim(NH) <- c(1, 5)
        dimnames(NH) <- list(Pr, Zile)
    }
    NH
}

