% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_3d_layers.R
\name{add_direction}
\alias{add_direction}
\title{A flexible function to add a line of predicted effects to the plotly surface with optional confidence intervals.}
\usage{
add_direction(
  p,
  model,
  direction_data,
  direction_name = "User defined line",
  linecolor = "black",
  ci = TRUE
)
}
\arguments{
\item{p}{A plotly object}

\item{model}{A glm with exactly two x variables}

\item{direction_data}{A data frame with a column of x1 values,
a column of x2 values, predicted y values and optional predicted
confidence interval for each pair of x values.
The variable names must be c("rownum", actual x1 variable name, actual x2 variable name,
actual y variable name, "lowerCI", "upperCI").}

\item{direction_name}{The hover text for the plotted line(s). Defaults to "User defined line".}

\item{linecolor}{The color for the plotted line. Defaults to "black".}

\item{ci}{An optional logical. Defaults to TRUE, showing the confidence intervals of the predicted effects.}
}
\value{
A plotly object
}
\description{
Primarily used by functions such as \code{add_3d_surface()} or \code{add_marginals()}.
If user defines \code{direction_data} appropriately, any line can be shown.
}
\examples{
library(plotly)
mymodel <- lm(r_shift ~ median_income16 + any_college, data = cali_counties)
xvars <- data.frame(x1 = seq(min(cali_counties$median_income16, na.rm=TRUE),
                             max(cali_counties$median_income16, na.rm=TRUE),
                              length.out=10),
                    x2 = seq(min(cali_counties$any_college, na.rm=TRUE),
                             max(cali_counties$any_college, na.rm=TRUE),
                             length.out=10))

predicted_xvars_data <- create_y_estimates(x_vals = xvars,
                                           model = mymodel,
                                           coefficient_names = c(y = "r_shift",
                                                                x1= "median_income16",
                                                                x2= "any_college") )
plot_ly( data = cali_counties,
         x = ~median_income16,
         y = ~any_college,
         z = ~r_shift) \%>\%
  add_markers(size = ~pop_estimate16, color = I('black')) \%>\%
  add_3d_surface(model = mymodel)\%>\%
  add_direction(model = mymodel, direction_data = predicted_xvars_data)

}
