% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_jitter_layers.R
\name{add_jitter}
\alias{add_jitter}
\title{Jitter scattercloud points}
\usage{
add_jitter(
  p,
  x = NULL,
  y = NULL,
  z = NULL,
  data = NULL,
  x_jitter = NULL,
  y_jitter = NULL,
  z_jitter = NULL,
  ...
)
}
\arguments{
\item{p}{a plotly object}

\item{x, y, z}{an optional x, y, and/or z variable.
Defaults to the data inherited from the plotly object p.}

\item{data}{an optional data frame.
Defaults to the data inherited from the plotly object p.}

\item{x_jitter, y_jitter, z_jitter}{Amount of vertical, horizontal, and depth jitter. The jitter is added in both positive and negative directions, so the total spread is twice the value specified here.
If omitted, defaults to 40\% of the spread in the data, so the jitter values will occupy 80\% of the implied bins.}

\item{...}{Arguments (i.e., attributes) passed along to the trace \code{type}.
See \code{\link[plotly:schema]{schema()}} for a list of acceptable attributes for a given trace \code{type}
(by going to \code{traces} -> \code{type} -> \code{attributes}). Note that attributes
provided at this level may override other arguments
(e.g. \code{plot_ly(x = 1:10, y = 1:10, color = I("red"), marker = list(color = "blue"))}).}
}
\value{
a plotly object
}
\description{
Add a jitter to a scatter trace with the mode of markers.
}
\details{
This adds a small amount of random variation to the location of each point, and
is a useful way of handling overplotting caused by discreteness.
It is based on ggplot's \code{ggplot2::geom_jitter()}.

The arguments \code{x_jitter}, \code{y_jitter}, \code{z_jitter} are not from plotly's syntax.
If these arguments are misspelled, plot_ly will generate a warning message listing all valid
arguments, but note that plotly uses the term attributes instead of arguments.
Since regress3d is an add on to plotly, this list of valid attributes does not
include the attributes/arguments created in this function.
}
\examples{
library(plotly)
plot_ly( data = hair_data,
              x = ~isFemale_num,
              y = ~isMale_num,
              z = ~length) \%>\%
     add_jitter( x_jitter = 0, z_jitter = 0, color = ~gender,
                colors = c("pink", "skyblue", "purple"))
}
