% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial-functions.R
\name{covar_taper}
\alias{covar_taper}
\alias{covar_exp}
\alias{covar_exppow}
\title{Tapered-spherical distance-based covariance function}
\usage{
covar_taper(d, theta, cor = NULL)

covar_exp(d, range)

covar_exppow(d, range, shape)
}
\arguments{
\item{d}{a numeric vector or matrix of distances}

\item{theta}{distance beyond which covariances are forced to 0.}

\item{cor}{optional correlation parameter. If included, the covariance is
subtracted from \code{cor}.}

\item{range}{range parameter}

\item{shape}{shape parameter}
}
\value{
a tapered-spherical transformation of d is returned.

the exponential covariance (v)

exponential-power covariance (v)
}
\description{
Tapered-spherical distance-based covariance function

Exponential distance-based covariance function

Exponential-power distance-based covariance function
}
\details{
\code{covar_taper} calculates covariance v as follows:

if \code{d <= theta}, then \code{v = ((1 - (d/theta))^2) * (1 + (d/(2 * theta)))}

if \code{d > theta}, then \code{v = 0}

\code{covar_exp} calculates covariance v as follows:

\code{v = exp(-d/range)}

\code{covar_exppow} calculates covariance v as follows:

\code{v = exp(-(d/range)^2)}

Note that \code{covar_exppow(..., shape = 1)} is equivalent to
\code{covar_exp()} but is needed as a separate function for use with \code{fitCor}.
}
\examples{

# simulate dummy data
map.width = 5 # square map width
coords = expand.grid(x = 1:map.width, y = 1:map.width) # coordinate matrix

# calculate distance
D = geosphere::distm(coords) # distance matrix

# visualize covariance matrix
image(covar_taper(D, theta = .5*max(D)))

# plot tapered covariance function
curve(covar_taper(x, theta = .5), from = 0, to = 1);abline(v = 0.5, lty = 2, col = "grey80")


# visualize covariance matrix
image(covar_exp(D, range = .2*max(D)))

# plot exponential function with different ranges
curve(covar_exp(x, range = .2), from = 0, to = 1)
curve(covar_exp(x, range = .1), from = 0, to = 1, col = "blue", add = TRUE)
legend("topright", legend = c("range = 0.2", "range = 0.1"), col = c("black", "blue"), lty = 1)


# visualize Exponential covariance matrix
image(covar_exppow(D, range = .2*max(D), shape = 1))

# visualize Exponential-power covariance matrix
image(covar_exppow(D, range = .2*max(D), shape = .5))

# plot exponential power function with different shapes
curve(covar_exppow(x, range = .2, shape = 1), from = 0, to = 1)
curve(covar_exppow(x, range = .2, shape = .5), from = 0, to = 1, col = "blue", add = TRUE)
legend("topright", legend = c("shape = 1.0", "shape = 0.5"), col = c("black", "blue"), lty = 1)

}
