% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitGLS_opt.R
\name{fitGLS_opt_FUN}
\alias{fitGLS_opt_FUN}
\title{Function that fitGLS_opt optimizes over}
\usage{
fitGLS_opt_FUN(
  op,
  fp,
  formula,
  data = NULL,
  coords,
  covar_FUN = "covar_exp",
  distm_FUN = "distm_scaled",
  is.trans = FALSE,
  backtrans = list(),
  ncores = NA
)
}
\arguments{
\item{op}{a named vector of parameters to be optimized}

\item{fp}{a named vector of fixed parameters}

\item{formula}{GLS model formula}

\item{data}{data source}

\item{coords}{a coordinate matrix}

\item{covar_FUN}{a covariance function}

\item{distm_FUN}{a distm function}

\item{is.trans}{logical: are any of the values in \code{op} or \code{fp}
transformed, needing back-transformation?}

\item{backtrans}{optional: a named list of functions used to backtransform any element
of \code{op} or \code{fp}. Names must correspond to names in \code{op}
or \code{fp}.}

\item{ncores}{an optional integer indicating how many CPU threads to use for calculations.}
}
\value{
\code{fitGLS_opt_FUN} returns the negative log likelihood of a GLS,
given the parameters in \code{op} and \code{fp}
}
\description{
Function that fitGLS_opt optimizes over
}
