% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{as.character.python.builtin.str}
\alias{as.character.python.builtin.str}
\title{Convert a Python string to an R Character Vector}
\usage{
\method{as.character}{python.builtin.str}(x, nul = stop("Embedded NUL in string."), ...)
}
\arguments{
\item{x}{A Python string}

\item{nul}{Action to take if the Python string contains an embedded NUL (\verb{\\x00}).
Python allows embedded \code{NUL}s in strings, while R does not. There are four
options for handling embedded \code{NUL}s:
\enumerate{
\item Error: This is the default
\item Replace: Supply a replacement string: \code{nul = "<NUL>"}
\item Remove: Supply an empty string: \code{nul = ""}
\item Split: Supply an R \code{NULL} to indicate that string should be split at embedded \code{NUL} bytes: \code{nul = NULL}
}}

\item{...}{Unused}
}
\value{
An R character vector. The returned vector will always of length 1,
unless \code{nul = NULL} was supplied.
}
\description{
Convert a Python string to an R Character Vector
}
\examples{
\dontshow{if (reticulate::py_available()) withAutoprint(\{ # examplesIf}
# Given a Python function that errors when it attempts to return
# a string with an embedded NUL
py_run_string('
def get_string_w_nul():
   return "a b" + chr(0) + "c d"
')
get_string_w_nul <- py$get_string_w_nul

try(get_string_w_nul()) # Error : Embedded NUL in string.

# To get the string into R, use `r_to_py()` on the function to stop it from
# eagerly converting the Python string to R, and then call `as.character()` with
# a `nul` argument supplied to convert the string to R.
get_string_w_nul <- r_to_py(get_string_w_nul)
get_string_w_nul() # unconverted python string: inherits(x, 'python.builtin.str')
as.character(get_string_w_nul(), nul = "<NUL>")  # Replace: "a b<NUL>c d"
as.character(get_string_w_nul(), nul = "")       # Remove: "a bc d"
as.character(get_string_w_nul(), nul = NULL)     # Split: "a b" "c d"

# cleanup example
rm(get_string_w_nul); py$get_string_w_nul <- NULL
\dontshow{\}) # examplesIf}
}
