% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fars_codebook}
\alias{fars_codebook}
\title{FARS Codebook}
\format{
A data frame with 15,951 rows and 19 variables:
\describe{
   \item{source}{The source of the data (either FARS or GES/CRSS).}
   \item{file}{The data file that contains the given variable.}
   \item{name_ncsa}{The original name of the data element.}
   \item{name_rfars}{The modified data element name used in rfars}
   \item{label}{The label of the data element itself (not its constituent values).}
   \item{Definition}{The data element's definition, pulled from the Analytical User Manual.}
   \item{Additional Information}{Additional information on the data element, pulled from the Analytical User Manual.}
   \item{value}{The original value of the data element.}
   \item{value_label}{The de-coded value label.}
   \item{2014}{Indicator: 1 if valid for 2014, NA otherwise.}
   \item{2015}{Indicator: 1 if valid for 2015, NA otherwise.}
   \item{2016}{Indicator: 1 if valid for 2016, NA otherwise.}
   \item{2017}{Indicator: 1 if valid for 2017, NA otherwise.}
   \item{2018}{Indicator: 1 if valid for 2018, NA otherwise.}
   \item{2019}{Indicator: 1 if valid for 2019, NA otherwise.}
   \item{2020}{Indicator: 1 if valid for 2020, NA otherwise.}
   \item{2021}{Indicator: 1 if valid for 2021, NA otherwise.}
   \item{2022}{Indicator: 1 if valid for 2022, NA otherwise.}
   \item{2023}{Indicator: 1 if valid for 2023, NA otherwise.}
   }
}
\usage{
fars_codebook
}
\description{
A table describing each FARS variable name, value, and corresponding value label.
}
\details{
This codebook serves as a useful reference for researchers using FARS data.
   The 'source' variable is intended to help combine with the gescrss_codebook.
   Data elements are relatively stable but are occasionally discontinued, created anew,
   or modified. The 'year' variable helps indicate the availability of data elements,
   and differentiates between different definitions over time. Users should always
   check for discontinuities when tabulating cases.

   The 'file' variable indicates the file in which the given data element originally appeared. Here, files refers to
   the SAS files downloaded from NHTSA. Most data elements stayed in their original
   file. Those that did not were moved to the multi_ files. For example, 'weather'
   originates from the 'accident' file, but appears in the multi_acc data object
   created by rfars.

   The 'name_ncsa' variable describes the data element's name as assigned
   by NCSA (the organization within NHTSA that manages the database). To maximize
   compatibility between years and ease of use for programming, 'name_rfars'
   provides a cleaned naming convention (via janitor::clean_names()).

   Each data element has a 'label', a more human-readable version of the
   element names. For example, the label for 'road_fnc' is 'Roadway Function Class'.
   These are not definitions but may provide enough information to help users
   conduct their analysis. Consult the \href{https://crashstats.nhtsa.dot.gov/Api/Public/ViewPublication/813706}{Analytical User’s Manual}
   for definitions and further details.

   'Definition' and 'Additional Information' were extracted from
   the \href{https://crashstats.nhtsa.dot.gov/Api/Public/ViewPublication/813706}{Analytical User’s Manual}.

   Each data element has multiple 'value'-'value_label' pairs: 'value' represents
   the original, non-human-readable value (usually a number), and 'value_label'
   represents the corresponding text value. For example, for 'road_fnc', 1 (the 'value')
   corresponds to 'Rural-Principal Arterial-Interstate' (the 'value_label'), 2 corresponds to
   'Rural-Principal Arterial-Other', etc.

 @source Codebooks are automatically generated by extracting SAS format catalogs
   (.sas7bcat files) and VALUE statements from .sas files during data processing,
   then consolidating variable names, labels, and value-label mappings across all
   years into searchable reference tables. Source files are published by NHTSA and available
   \href{https://www.nhtsa.gov/file-downloads?p=nhtsa/downloads/}{here}.
}
\examples{
head(rfars::fars_codebook)
}
\seealso{
"gescrss_codebook"
}
\keyword{datasets}
