% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdensity.R
\name{densityanomaly}
\alias{densityanomaly}
\title{Plot Difference from Mean Kernel Density Using River Distance}
\usage{
densityanomaly(
  x,
  whichplots = NULL,
  method = c("overlap", "both", "positive", "negative"),
  negative_ramp = "blue",
  positive_ramp = "red",
  parmfrow = NULL,
  ...
)
}
\arguments{
\item{x}{An object returned from \link{makeriverdensity}.}

\item{whichplots}{A vector of plots to produce, if multiple plots are 
produced.  For example, specifying \code{whichplot=c(2,3,4)} will result in
only the second, third, and fourth plots of the sequence being produced. 
Accepting the default (\code{NULL}) will result in all plots being 
produced.  Note: this will also be the set of kernel densities used to 
calculate the mean kernel density and thereby differences from mean kernel
density.}

\item{method}{Whether to produce plots for positive and negative anomalies
overlayed (\code{"overlay"}), in sequence (\code{"both"}), or positive or 
negative only (\code{"positive"} or \code{"negative"}).}

\item{negative_ramp}{Color ramp to use for negative anomaly (see \link{plot.riverdensity}
for more details).  Defaults to \code{"blue"}.}

\item{positive_ramp}{Color ramp to use for negative anomaly (see \link{plot.riverdensity}
for more details).  Defaults to \code{"red"}.}

\item{parmfrow}{Optional argument to \code{par(mfrow)=}, which may be useful if
\code{method="both"}.  Defaults to \code{NULL}.}

\item{...}{Additional arguments to \link{plot.riverdensity}.}
}
\value{
\code{NULL}
}
\description{
Plots kernel density anomaly for each survey, which is defined as 
the difference between kernel density for each survey and mean kernel density 
across all surveys.  The intent of this function is to highlight areas in which 
density is higher or lower for specific surveys than it is on average.

The input argument is an object returned from \link{makeriverdensity}.
}
\examples{
data(Gulk, fakefish)

Gulk_dens <- makeriverdensity(seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk, 
  survey=fakefish$flight.date)
  
# first, the behavior of plot.riverdensity
# # 10 plots will be created, recommend calling par(mfrow=c(2,5))
plot(x=Gulk_dens)

# next, showing densityanomaly
densityanomaly(x=Gulk_dens, parmfrow=c(2,5))
densityanomaly(x=Gulk_dens, method="negative", parmfrow=c(2,5))
densityanomaly(x=Gulk_dens, method="positive", parmfrow=c(2,5))
}
\seealso{
\link{makeriverdensity}, \link{plot.riverdensity}, \link{plotriverdensitypoints}
}
\author{
Matt Tyers
}
