% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnrs.R
\name{tnrs_match_names}
\alias{tnrs_match_names}
\title{Match names to the Open Tree Taxonomy}
\usage{
tnrs_match_names(
  names = NULL,
  context_name = "All life",
  do_approximate_matching = TRUE,
  ids = NULL,
  include_suppressed = FALSE,
  ...
)
}
\arguments{
\item{names}{taxon names to be queried. Currently limited to 10,000 names
for exact matches and 2,500 names for approximate matches (character
vector)}

\item{context_name}{name of the taxonomic context to be searched (length-one
character vector or \code{NULL}). Must match (case sensitive) one of the
values returned by \code{\link{tnrs_contexts}}. Default to "All life".}

\item{do_approximate_matching}{A logical indicating whether or not to
perform approximate string (a.k.a. \dQuote{fuzzy}) matching. Using
\code{FALSE} will greatly improve speed. Default, however, is \code{TRUE}.}

\item{ids}{A vector of ids to use for identifying names. These will be
assigned to each name in the names array. If ids is provided, then ids and
names must be identical in length.}

\item{include_suppressed}{Ordinarily, some quasi-taxa, such as incertae
sedis buckets and other non-OTUs, are suppressed from TNRS results. If
this parameter is true, these quasi-taxa are allowed as possible TNRS
results.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
A data frame summarizing the results of the query. The original
  query output is appended as an attribute to the returned object (and can
  be obtained using \code{attr(object, "original_response")}).
}
\description{
Match taxonomic names to the Open Tree Taxonomy.
}
\details{
Accepts one or more taxonomic names and returns information about
potential matches for these names to known taxa in the Open Tree
Taxonomy.

This service uses taxonomic contexts to disambiguate homonyms and misspelled
names; a context may be specified using the \code{context_name} argument.
The default value for \code{context_name} is "All life". If no context is
specified (i.e., \code{context_name} is set to \code{NULL}), then the
context will be inferred (i.e., the shallowest taxonomic context that
contains all unambiguous names in the input). Taxonomic contexts are
uncontested higher taxa that have been selected to allow limits to be
applied to the scope of TNRS searches (e.g. 'match names only within
flowering plants'). Once a context has been identified (either
user-specified or inferred), all taxon name matches will performed only
against taxa within that context. For a list of available taxonomic
contexts, see \code{\link{tnrs_contexts}}.

A name is considered unambiguous if it is not a synonym and has
only one exact match to any taxon name in the entire taxonomy.

When the name search returns multiple matches, the taxon with the highest
match score is returned. If the name returned is not the one you intended,
you can use the \code{inspect} function to check the other taxa returned by
your search. The
\href{https://docs.ropensci.org/rotl/articles/rotl.html#how-to-change-the-ott-ids-assigned-to-my-taxa}{Getting
Started vignette} has more information on how to do this.

Several functions listed in the \sQuote{See also} section can be
used to inspect and manipulate the object generated by this
function.
}
\examples{
\dontrun{
 deuterostomes <- tnrs_match_names(names=c("echinodermata", "xenacoelomorpha",
                                            "chordata", "hemichordata"))
}
}
\seealso{
\code{\link{inspect.match_names}},
  \code{\link{update.match_names}}, \code{\link{synonyms.match_names}}.
}
