% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_roclet.R
\name{tests_roclet}
\alias{tests_roclet}
\title{tests_roclet}
\usage{
tests_roclet()
}
\value{
A complete roclet.
}
\description{
This roclet automates the creation of unit tests, using \code{@tests} tags
written in the function definition files, and processed using \code{roxygen2}.
The unit tests are written verbatim to the appropriate destination file.
}
\examples{
# In actual use, the test lines would be in your function definition file.
# The results (cat'd here) would be written to the unit test file.
# If the function definition file is myFunc.R then the results
# are written to test-myFunc.R in the appropriate directory
# (the directory depends on whether your are using tinytest or testthat).

tinytest_in <- "#' @tests tinytest\n#' # Are these equal?\n#' expect_equal(5.0, 5.0)\nNULL\n"
tinytest_out <- roxygen2::roc_proc_text(tests_roclet(), tinytest_in)
cat(tinytest_out$tinytest, "\n")

testthat_in <- "#' @tests testthat\n#' # Are these equal?\n#' expect_equal(5.0, 5.0)\nNULL\n"
testthat_out <- roxygen2::roc_proc_text(tests_roclet(), testthat_in)
cat(testthat_out$testthat, "\n")

}
\author{
Bryan A. Hanson
}
