% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumericGap.R
\name{numericGap}
\alias{numericGap}
\alias{gapNumeric}
\title{Create object \link{NumericGap}}
\usage{
numericGap(
  solution,
  response_identifier = generate_id(type = "gap"),
  points = 1,
  placeholder = "",
  expected_length = size_gap(solution),
  tolerance = 0,
  tolerance_type = "absolute",
  include_lower_bound = TRUE,
  include_upper_bound = TRUE
)

gapNumeric(
  solution,
  response_identifier = generate_id(type = "gap"),
  points = 1,
  placeholder = "",
  expected_length = size_gap(solution),
  tolerance = 0,
  tolerance_type = "absolute",
  include_lower_bound = TRUE,
  include_upper_bound = TRUE
)
}
\arguments{
\item{solution}{A numeric value containing the correct answer for this numeric
entry.}

\item{response_identifier}{A character value representing an identifier for
the answer. By default, it is generated as 'id_gap_dddd', where dddd
represents random digits.}

\item{points}{A numeric value, optional, representing the number of points for
this gap. Default is 1}

\item{placeholder}{A character value, optional, responsible for placing
helpful text in the text input field in the content delivery engine. Default
is "".}

\item{expected_length}{A numeric value, optional, responsible for setting the
size of the text input field in the content delivery engine. Default value
is adjusted by solution size.}

\item{tolerance}{A numeric value, optional, specifying the value for the upper
and lower boundaries of the tolerance rate for candidate answers. Default is
0.}

\item{tolerance_type}{A character value, optional, specifying the tolerance
mode. Possible values:
\itemize{
\item "exact"
\item "absolute" - Default.
\item "relative"
}}

\item{include_lower_bound}{A boolean value, optional, specifying whether the
lower bound is included in the tolerance rate. Default is \code{TRUE}.}

\item{include_upper_bound}{A boolean value, optional, specifying whether the
upper bound is included in the tolerance rate. Default is \code{TRUE}.}
}
\value{
An object of class \link{NumericGap}
}
\description{
Create object \link{NumericGap}
}
\examples{
ng_min <- numericGap(5.1)

ng <- numericGap(solution = 5.1,
                response_identifier  = "id_gap_1234",
                points = 2,
                placeholder = "put your answer here",
                expected_length = 4,
                tolerance = 5,
                tolerance_type = "relative")
}
\seealso{
[entry()][textGap()][textGapOpal()]
}
