% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_controller.R
\name{topo_sort_tables}
\alias{topo_sort_tables}
\title{Topologically sort join plan so values are available before uses.}
\usage{
topo_sort_tables(columnJoinPlan, leftTableName, ...)
}
\arguments{
\item{columnJoinPlan}{join plan}

\item{leftTableName}{which table is left}

\item{...}{force later arguments to bind by name}
}
\value{
list with dependencyGraph and sorted columnJoinPlan
}
\description{
Depends on \code{igraph} package.
Please see \code{vignette('DependencySorting', package = 'rquery')} and \code{vignette('joinController', package= 'rquery')} for more details.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE) &&
    requireNamespace('igraph', quietly = TRUE)) {
  # note: employeeanddate is likely built as a cross-product
  #       join of an employee table and set of dates of interest
  #       before getting to the join controller step.  We call
  #       such a table "row control" or "experimental design."
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(my_db)
  tDesc <- example_employee_date(my_db)
  columnJoinPlan <- build_join_plan(tDesc, check= FALSE)
  # unify keys
  columnJoinPlan$resultColumn[columnJoinPlan$resultColumn=='id'] <- 'eid'
  # look at plan defects
  print(paste('problems:',
              inspect_join_plan(tDesc, columnJoinPlan)))
  # fix plan
  sorted <- topo_sort_tables(columnJoinPlan, 'employeeanddate')
  print(paste('problems:',
              inspect_join_plan(tDesc, sorted$columnJoinPlan)))
  print(plot(sorted$dependencyGraph))
  DBI::dbDisconnect(my_db)
  my_db <- NULL
}

}
