% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-asymsam.R
\name{download_asymsam_monthly}
\alias{download_asymsam_monthly}
\alias{download_asymsam_daily}
\title{Download Asymmetric and Symmetric SAM indices}
\usage{
download_asymsam_monthly(use_cache = FALSE, file = NULL)

download_asymsam_daily(levels = 700, use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}

\item{levels}{atmospheric levels in hPa to download. 
If \code{"all"} download all available levels. 
Available levels are: 1, 2, 3, 5, 7, 10, 20, 30, 50, 70, 100, 125, 150, 175,
 200, 225, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 775, 800,
 825, 850, 875, 900, 925, 950, 975 and 1000.}
}
\value{
\itemize{
\item Lev: Atmospheric level in hPa
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Index: Type of index. Either "sam", "ssam" or "asam".
\item Value: Value of the index
\item Value_normalized: Value of the index normalized by the standard deviation of the index
\item R.squared: The variance explained by the index (only in the daily version)
}
}
\description{
The Asymmetric and Symmetric SAM indices are computed as the 
projection of geopotential height anomalies onto the zonally asymmetric and 
zonally symmetric parts of the SAM field. 
The detailed methodology can be found in Campitelli et al. (2022).
The source of the data is \url{https://www.cima.fcen.uba.ar/~elio.campitelli/asymsam/}
}
\examples{
\dontrun{
asymsam <- download_asymsam_monthly()
}

}
\references{
Campitelli, E., Díaz, L. B., & Vera, C. (2022). Assessment of zonally symmetric and asymmetric components of the Southern Annular Mode using a novel approach. Climate Dynamics, 58(1), 161–178. \doi{10.1007/s00382-021-05896-5}
}
