% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aupvb.R
\name{load_aupvb_pbp}
\alias{load_aupvb_pbp}
\title{Load cleaned aupvb pbp data from the volleydata repository.}
\usage{
load_aupvb_pbp(seasons = NULL)
}
\arguments{
\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing play-by-play data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   season \tab dbl \cr
   week_number \tab dbl \cr
   game_number \tab dbl \cr
   play_sequence_number \tab dbl \cr
   set_number \tab dbl \cr
   rally_number \tab dbl \cr
   play_code \tab chr \cr
   narrative_formatted \tab chr \cr
   played_id \tab dbl \cr
   serve_ace \tab lgl \cr
   serve_error \tab lgl \cr
   serve_continue \tab lgl \cr
   attack_kill \tab lgl \cr
   attack_error \tab lgl \cr
   attack_continue \tab lgl \cr
   pass_good \tab lgl \cr
   pass_error \tab lgl \cr
   pass_continue \tab lgl \cr
   dig_success \tab lgl \cr
   dig_continue \tab lgl \cr
   block_stuff \tab lgl \cr
   block_assist \tab lgl \cr
   block_continue \tab lgl \cr
   set_assist \tab lgl \cr
   set_error \tab lgl \cr
   set_continue \tab lgl \cr
   home_team_score \tab dbl \cr
   away_team_score \tab dbl \cr
   scoring_team_id \tab dbl \cr
   home_team_id \tab dbl \cr
   away_team_id \tab dbl \cr
   set_status_lk \tab chr \cr
   season_id \tab dbl \cr
   game_id \tab dbl \cr
   play_text \tab chr \cr
   start_time \tab dbl \cr
   end_time \tab dbl \cr
   video_minutes \tab dbl \cr
   video_seconds \tab dbl \cr
   alternate_video_seconds \tab dbl \cr
   date_time_file_received \tab chr \cr
}
}
\description{
Load cleaned aupvb pbp data from the volleydata repository.
}
\examples{
\donttest{try({load_aupvb_pbp(2024)})}
}
