% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{history_daily}
\alias{history_daily}
\title{Summarized weather data for specified date.}
\usage{
history_daily(location, date = "20150101", use_metric = FALSE,
  key = get_api_key(), raw = FALSE, message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{date}{Date as YYYYMMDD format}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df of summarized weather
}
\description{
Summarized weather data for specified date.
}
\examples{
\dontrun{
history_daily(set_location(territory = "Hawaii", city = "Honolulu"), "20130101")
history_daily(set_location(airport_code = "SEA"), "20130101")
history_daily(set_location(zip_code = "90210"), "20130131")
history_daily(set_location(territory = "IR", city = "Tehran"), "20140131")
}
}
