% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataZIB.R
\docType{data}
\name{dataZIB}
\alias{dataZIB}
\title{Sample Data for Small Area Estimation using Hierarchical Bayesian Method under Zero-Inflated Binomial Distribution}
\format{
A data frame with 64 observations on the following 4 variables:
\describe{
  \item{y}{Direct Estimation of y}
  \item{X1}{Auxiliary variable of x1}
  \item{X2}{Auxiliary variable of x2}
  \item{vardir}{sampling variance of y}
  \item{s}{number of sample}
}
}
\usage{
data(dataZIB)
}
\description{
Dataset to simulate Small Area Estimation using Hierarchical Bayesian Method under Zero-Inflated Binomial distribution

This data is generated by these following steps:
\enumerate{
  \item Generate sampling random area effect u.Z and u.nZ with \eqn{(u.Z ~ N(0,1))} and \eqn{(u.nZ ~ N(0,1))}. The auxilary variabels are generated by Uniform distribution with \eqn{(x1 ~ U(0,1))} and \eqn{(x2 ~ U(1,5))}. The coefficient parameters \eqn{\alpha0, \alpha1, \alpha2, \beta0, \beta1, \beta2} are set as 0.
  \item Calculate \eqn{logit(p)=\alpha0 + \alpha1 * x1+ \alpha2 * x2 + u.Z} and \eqn{logit(\pi)=\beta0 + \beta1 * x1 +\beta2 * x2 + u.nZ}
  \item Generate number of sample with \eqn{n.samp ~ U(10,30)}
  \item Generate \eqn{delta ~ bernoulli(p)} and \eqn{y_star ~ binomial(s, \pi)}
  \item calculate \eqn{y = delta*y_star}
  \item Calculate variance of direct estimates (vardir) with \eqn{var (y) = (1-p)*s*pi*(1-\pi*(1-p*s))}
  \item Auxilary variables x1, x2, direct estimation \eqn{(y)}, vardir, and s are combined in a dataframe called dataZIB
}
}
\keyword{datasets}
