% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.as.jury.stats.r
\name{sim.as.jury.stats}
\alias{sim.as.jury.stats}
\title{Estimates jury-level probability of guilty verdict based on juror-level statistics based on empirical data}
\usage{
sim.as.jury.stats(
  sample_pg,
  sample_n,
  jury_n = 12,
  pstrikes = 0,
  dstrikes = 0,
  accuracy = 0.15,
  digits = 3,
  nDraws = 10000,
  seed = 12345
)
}
\arguments{
\item{sample_pg}{The proportion of jurors who favor a guilty verdict in the jury pool}

\item{sample_n}{The size of the sample used to estimate sample_pg}

\item{jury_n}{Size of the jury (i.e. 6, 8, or 12); default value is 12.}

\item{pstrikes}{Number of peremptory strikes by prosecution; default value is 0.}

\item{dstrikes}{Number of peremptory strikes by defendant; default value is 0.}

\item{accuracy}{Accuracy of parties' peremptory strikes; a number between 0 and 1; default value is .15.}

\item{digits}{Number of digits to report after decimal places; default value is 3.}

\item{nDraws}{The number of simulations used to generate results. Should be very large number (default = 10000).}

\item{seed}{Set seed for random number generation for replication, default is 12345.}
}
\value{
Returns a list of jury-level statistics to assess effect of a trial error.
}
\description{
Returns estimate of the probability of guilty verdict based on juror-level
             statistics supplied by user. Also reports inferential statistics. Results
             are based on an empirical model with greater uncertainty than as.jury.stats
             function.
}
\examples{
   library(sate)
   sim.as.jury.stats(sample_pg=.50, sample_n=830, nDraws=500)

   sim.as.jury.stats(sample_pg=10/12, sample_n=295, pstrikes=6, dstrikes=10, nDraws=1000)
}
