% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{drill_set}
\alias{drill_set}
\title{Set Drill SYSTEM or SESSION options}
\usage{
drill_set(drill_con, ..., type = c("session", "system"))
}
\arguments{
\item{drill_con}{drill server connection object setup by \code{drill_connection()}}

\item{...}{named parameters to be sent to \verb{ALTER SYSTEM} or \verb{ALTER SESSION}}

\item{type}{set the \code{session} or \code{system} parameter}
}
\value{
a \code{tbl} (invisibly) with the \code{ALTER} queries sent and results, including errors.
}
\description{
Helper function to make it more R-like to set Drill SESSION or SYSTEM optons. It
handles the conversion of R types (like \code{TRUE}) to SQL types and automatically
quotes parameter values (when necessary).
}
\details{
If any query errors result, error messages will be presented to the console.
}
\examples{
\dontrun{
drill_connection() \%>\%
  drill_set(exec.errors.verbose=TRUE, store.format="parquet", web.logs.max_lines=20000)
}
}
\references{
\href{https://drill.apache.org/docs/}{Drill documentation}
}
\seealso{
Other Drill direct REST API Interface: 
\code{\link{drill_active}()},
\code{\link{drill_cancel}()},
\code{\link{drill_connection}()},
\code{\link{drill_functions}()},
\code{\link{drill_metrics}()},
\code{\link{drill_options}()},
\code{\link{drill_opts}()},
\code{\link{drill_profiles}()},
\code{\link{drill_profile}()},
\code{\link{drill_query}()},
\code{\link{drill_settings_reset}()},
\code{\link{drill_stats}()},
\code{\link{drill_status}()},
\code{\link{drill_storage}()},
\code{\link{drill_system_reset}()},
\code{\link{drill_threads}()},
\code{\link{drill_version}()}
}
\concept{Drill direct REST API Interface}
